/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.client.gui.elements;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.phosphophyllite.client.gui.ScreenCallbacks;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class InteractiveElement<T extends AbstractContainerMenu>
extends RenderedElement<T>
implements GuiEventListener {
    public boolean actionEnable = true;
    public ScreenCallbacks.OnMouseMoved onMouseMoved;
    public ScreenCallbacks.OnMouseClicked onMouseClicked;
    public ScreenCallbacks.OnMouseReleased onMouseReleased;
    public ScreenCallbacks.OnMouseDragged onMouseDragged;
    public ScreenCallbacks.OnMouseScrolled onMouseScrolled;
    public ScreenCallbacks.OnKeyPressed onKeyPressed;
    public ScreenCallbacks.OnKeyReleased onKeyReleased;
    public ScreenCallbacks.OnCharTyped onCharTyped;

    public InteractiveElement(@Nonnull PhosphophylliteScreen<T> parent, int x, int y, int width, int height, int u, int v, @Nullable Component tooltip) {
        super(parent, x, y, width, height, u, v, tooltip);
    }

    public void playSound(Holder.Reference<SoundEvent> sound) {
        this.playSound((SoundEvent)sound.get());
    }

    public void playSound(SoundEvent sound) {
        this.parent.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)1.0f));
    }

    public void playSound(SoundEvent sound, float volume) {
        this.parent.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)1.0f, (float)volume));
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.actionEnable && this.onMouseMoved != null) {
            this.onMouseMoved.trigger(mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.actionEnable && this.onMouseClicked != null) {
            return this.onMouseClicked.trigger(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.actionEnable && this.onMouseReleased != null) {
            return this.onMouseReleased.trigger(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.actionEnable && this.onMouseDragged != null) {
            return this.onMouseDragged.trigger(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.actionEnable && this.onMouseScrolled != null) {
            return this.onMouseScrolled.trigger(mouseX, mouseY, delta);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.actionEnable && this.onKeyPressed != null) {
            return this.onKeyPressed.trigger(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.actionEnable && this.onKeyReleased != null) {
            return this.onKeyReleased.trigger(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.actionEnable && this.onCharTyped != null) {
            return this.onCharTyped.trigger(codePoint, modifiers);
        }
        return false;
    }

    @Override
    public void enable() {
        super.enable();
        this.actionEnable = true;
    }

    @Override
    public void disable() {
        super.disable();
        this.actionEnable = false;
    }
}

