/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.client.render;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;

public class ElevatorBakedModel
extends BakedModelWrapper<BakedModel> {
    public static final ModelProperty<BlockState> HELD_STATE = new ModelProperty();

    public ElevatorBakedModel(BakedModel originalModel) {
        super(originalModel);
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        BlockState state = (BlockState)data.get(HELD_STATE);
        if (state != null) {
            return Minecraft.m_91087_().m_91289_().m_110910_(state).getParticleIcon(data);
        }
        return super.getParticleIcon(data);
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState heldState = (BlockState)data.get(HELD_STATE);
        ChunkRenderTypeSet types = heldState != null ? Minecraft.m_91087_().m_91289_().m_110910_(heldState).getRenderTypes(heldState, rand, data) : super.getRenderTypes(state, rand, data);
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{types, ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110457_()})});
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState heldState;
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        if (renderType == RenderType.m_110457_() && side == null && ((Boolean)state.m_61143_((Property)ElevatorBlock.DIRECTIONAL)).booleanValue() && ((Boolean)state.m_61143_((Property)ElevatorBlock.SHOW_ARROW)).booleanValue()) {
            BakedModel arrowModel = dispatcher.m_110907_().m_110881_().getModel(new ResourceLocation("elevatorid", "arrow"));
            BlockModelRotation rot = BlockModelRotation.m_119153_((int)0, (int)((int)((Direction)state.m_61143_((Property)ElevatorBlock.f_54117_)).m_122435_()));
            IQuadTransformer transformer = QuadTransformers.applying((Transformation)rot.m_6189_().blockCenterToCorner());
            result.addAll(transformer.process(arrowModel.getQuads(state, null, rand, extraData, renderType)));
        }
        if ((heldState = (BlockState)extraData.get(HELD_STATE)) != null) {
            ChunkRenderTypeSet types = Minecraft.m_91087_().m_91289_().m_110910_(heldState).getRenderTypes(heldState, rand, ModelData.EMPTY);
            if (renderType == null || types.contains(renderType)) {
                BakedModel model = dispatcher.m_110910_(heldState);
                result.addAll(model.getQuads(heldState, side, rand, extraData, renderType));
            }
            return result;
        }
        result.addAll(this.originalModel.getQuads(state, side, rand, extraData, renderType));
        return result;
    }
}

