/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.xmod.mek;

import appeng.api.config.Actionable;
import com.glodblock.github.appflux.util.TileCache;
import com.glodblock.github.appflux.xmod.mek.MekEnergy;
import mekanism.api.Action;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.tile.multiblock.TileEntityInductionPort;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MekInductionPortHandler
implements MekEnergy {
    private final TileCache cache;

    protected MekInductionPortHandler(ServerLevel level, BlockPos fromPos) {
        this.cache = TileCache.create(level, fromPos);
    }

    private static FloatingLong FE2J() {
        return (FloatingLong)MekanismConfig.general.forgeConversionRate.get();
    }

    @Override
    public boolean valid() {
        return this.cache.find() instanceof TileEntityInductionPort;
    }

    @Override
    public long getStored() {
        if (this.valid()) {
            TileEntityInductionPort port = (TileEntityInductionPort)this.cache.find();
            assert (port != null);
            return ((MatrixMultiblockData)port.getMultiblock()).getEnergy().divide(MekInductionPortHandler.FE2J()).longValue();
        }
        return 0L;
    }

    @Override
    public long input(long power, Actionable mode, Direction side) {
        if (this.valid()) {
            TileEntityInductionPort port = (TileEntityInductionPort)this.cache.find();
            assert (port != null);
            FloatingLong add = FloatingLong.create((long)power).multiply(MekInductionPortHandler.FE2J());
            FloatingLong left = ((MatrixMultiblockData)port.getMultiblock()).insertEnergy(add, side, Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction()));
            return FloatingLong.create((long)power).subtract(left.divide(MekInductionPortHandler.FE2J())).longValue();
        }
        return 0L;
    }

    @Override
    public long output(long power, Actionable mode, Direction side) {
        if (this.valid()) {
            TileEntityInductionPort port = (TileEntityInductionPort)this.cache.find();
            assert (port != null);
            FloatingLong drain = FloatingLong.create((long)power).multiply(MekInductionPortHandler.FE2J());
            FloatingLong left = ((MatrixMultiblockData)port.getMultiblock()).extractEnergy(drain, side, Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction()));
            return left.divide(MekInductionPortHandler.FE2J()).longValue();
        }
        return 0L;
    }
}

