/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.mixins;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import com.glodblock.github.appflux.common.AFItemAndBlock;
import com.glodblock.github.appflux.common.me.energy.EnergyHandler;
import com.glodblock.github.appflux.common.me.service.IEnergyDistributor;
import com.glodblock.github.appflux.util.AFUtil;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderLogic.class}, remap=false)
public abstract class MixinPatternProviderLogic
implements IUpgradeableObject,
IEnergyDistributor {
    @Unique
    private IUpgradeInventory af_$upgrades = UpgradeInventories.empty();
    @Final
    @Shadow
    private PatternProviderLogicHost host;
    @Final
    @Shadow
    private IManagedGridNode mainNode;
    @Final
    @Shadow
    private IActionSource actionSource;

    @Unique
    private void af_$onUpgradesChanged() {
        this.host.saveChanges();
    }

    public IUpgradeInventory getUpgrades() {
        return this.af_$upgrades;
    }

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")})
    private void initUpgrade(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        this.af_$upgrades = UpgradeInventories.forMachine((ItemLike)host.getTerminalIcon().getItem(), (int)1, this::af_$onUpgradesChanged);
        this.mainNode.addService(IEnergyDistributor.class, (IGridNodeService)this);
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void saveUpgrade(CompoundTag tag, CallbackInfo ci) {
        this.af_$upgrades.writeToNBT(tag, "upgrades");
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void loadUpgrade(CompoundTag tag, CallbackInfo ci) {
        this.af_$upgrades.readFromNBT(tag, "upgrades");
    }

    @Inject(method={"addDrops"}, at={@At(value="TAIL")})
    private void dropUpgrade(List<ItemStack> drops, CallbackInfo ci) {
        for (ItemStack is : this.af_$upgrades) {
            if (is.m_41619_()) continue;
            drops.add(is);
        }
    }

    @Inject(method={"clearContent"}, at={@At(value="TAIL")})
    private void clearUpgrade(CallbackInfo ci) {
        this.af_$upgrades.clear();
    }

    @Override
    public void distribute() {
        if (this.af_$upgrades.isInstalled((ItemLike)AFItemAndBlock.INDUCTION_CARD)) {
            IStorageService storage = this.af_getStorage();
            IGrid gird = this.mainNode.getGrid();
            BlockEntity self = this.host.getBlockEntity();
            if (storage != null && self.m_58904_() != null) {
                for (Direction d : AFUtil.getSides(this.host)) {
                    BlockEntity te = self.m_58904_().m_7702_(self.m_58899_().m_121955_(d.m_122436_()));
                    IGrid thatGrid = AFUtil.getGrid(te, d.m_122424_());
                    if (te == null || thatGrid == gird || AFUtil.isBlackListTE(te, d.m_122424_())) continue;
                    EnergyHandler.send(te, d.m_122424_(), storage, this.actionSource);
                }
            }
        }
    }

    @Unique
    private IStorageService af_getStorage() {
        if (this.mainNode.getGrid() != null) {
            return this.mainNode.getGrid().getStorageService();
        }
        return null;
    }
}

