/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.tileentities;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.blockentity.grid.AENetworkBlockEntity;
import com.glodblock.github.appflux.common.AFItemAndBlock;
import com.glodblock.github.appflux.common.me.energy.CapAdaptor;
import com.glodblock.github.appflux.common.me.energy.EnergyHandler;
import com.glodblock.github.appflux.common.me.service.IEnergyDistributor;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.appflux.util.AFUtil;
import com.glodblock.github.glodium.util.GlodUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileFluxAccessor
extends AENetworkBlockEntity
implements IEnergyDistributor {
    public TileFluxAccessor(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileFluxAccessor.class, TileFluxAccessor::new, (Block)AFItemAndBlock.FLUX_ACCESSOR), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.getMainNode().setIdlePowerUsage(1.0).addService(IEnergyDistributor.class, (IGridNodeService)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        CapAdaptor.Factory handler = CapAdaptor.find(cap);
        if (handler != null) {
            return LazyOptional.of(() -> handler.create(this.getStorage(), this.getSource()));
        }
        return super.getCapability(cap, side);
    }

    private IStorageService getStorage() {
        if (this.getGridNode() != null) {
            return this.getGridNode().getGrid().getStorageService();
        }
        return null;
    }

    private IActionSource getSource() {
        return IActionSource.ofMachine((IActionHost)this);
    }

    @Override
    public void distribute() {
        IStorageService storage = this.getStorage();
        IGrid gird = AFUtil.getGrid(this, null);
        if (storage != null && this.f_58857_ != null) {
            for (Direction d : Direction.values()) {
                BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121955_(d.m_122436_()));
                IGrid thatGrid = AFUtil.getGrid(te, d.m_122424_());
                if (te == null || thatGrid == gird || AFUtil.isBlackListTE(te, d.m_122424_())) continue;
                EnergyHandler.send(te, d.m_122424_(), storage, this.getSource());
            }
        }
    }

    @Override
    public void charge() {
        if (AFConfig.selfCharge()) {
            IStorageService storage = this.getStorage();
            IGrid gird = AFUtil.getGrid(this, null);
            if (storage != null && gird != null) {
                EnergyHandler.chargeNetwork((IEnergyService)gird.getService(IEnergyService.class), storage, this.getSource());
            }
        }
    }
}

