/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.registry;

import com.smashingmods.chemlib.api.ChemicalBlockType;
import com.smashingmods.chemlib.common.blocks.ChemicalBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"chemlib");
    public static final List<ChemicalBlock> METAL_BLOCKS = new ArrayList<ChemicalBlock>();
    public static final List<ChemicalBlock> LAMP_BLOCKS = new ArrayList<ChemicalBlock>();
    public static final BlockBehaviour.Properties METAL_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 12.0f).m_60918_(SoundType.f_56743_);
    public static final BlockBehaviour.Properties LAMP_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60918_(SoundType.f_56744_).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0);

    public static Optional<RegistryObject<Block>> getRegistryObjectByName(String pName) {
        return BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.getId().m_135815_().equals(pName)).findFirst();
    }

    public static List<ChemicalBlock> getAllChemicalBlocks() {
        ArrayList<ChemicalBlock> all = new ArrayList<ChemicalBlock>();
        all.addAll(METAL_BLOCKS);
        all.addAll(LAMP_BLOCKS);
        return all;
    }

    public static List<ChemicalBlock> getChemicalBlocksByType(ChemicalBlockType pChemicalBlockType) {
        return switch (pChemicalBlockType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalBlockType.METAL -> METAL_BLOCKS;
            case ChemicalBlockType.LAMP -> LAMP_BLOCKS;
        };
    }

    public static Stream<ChemicalBlock> getChemicalBlocksStreamByType(ChemicalBlockType pChemicalBlockType) {
        return BlockRegistry.getChemicalBlocksByType(pChemicalBlockType).stream().filter(block -> block.getBlockType().equals((Object)pChemicalBlockType));
    }

    public static Optional<ChemicalBlock> getChemicalBlockByNameAndType(String pName, ChemicalBlockType pChemicalBlockType) {
        return BlockRegistry.getChemicalBlocksStreamByType(pChemicalBlockType).filter(block -> block.getChemical().getChemicalName().equals(pName)).findFirst();
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

