/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.client.events;

import com.smashingmods.chemlib.registry.BlockRegistry;
import com.smashingmods.chemlib.registry.FluidRegistry;
import com.smashingmods.chemlib.registry.ItemRegistry;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="chemlib")
public class ClientEventHandler {
    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            FluidRegistry.getFluidsAsStream().forEach(fluid -> ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)RenderType.m_110451_()));
            FluidRegistry.getLiquidBlocks().forEach(liquidBlock -> ItemBlockRenderTypes.setRenderLayer((Block)liquidBlock, (RenderType)RenderType.m_110451_()));
        });
    }

    @SubscribeEvent
    public static void onItemColorHandlerEvent(RegisterColorHandlersEvent.Item event) {
        ItemRegistry.getElements().forEach(element -> event.register(element::getColor, new ItemLike[]{element}));
        ItemRegistry.getCompounds().forEach(compound -> event.register(compound::getColor, new ItemLike[]{compound}));
        ItemRegistry.getChemicalItems().forEach(item -> event.register(item::getColor, new ItemLike[]{item}));
        ItemRegistry.getChemicalBlockItems().forEach(item -> event.register(item::getColor, new ItemLike[]{item}));
        FluidRegistry.getBuckets().forEach(bucket -> event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{bucket}));
    }

    @SubscribeEvent
    public static void onBlockColorHandlerEvent(RegisterColorHandlersEvent.Block event) {
        BlockRegistry.getAllChemicalBlocks().forEach(block -> event.register(block.getBlockColor(new ItemStack((ItemLike)block.m_5456_()), 0), new Block[]{block}));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)new ModelResourceLocation(new ResourceLocation("chemlib", "element_solid_model"), "inventory"));
        event.register((ResourceLocation)new ModelResourceLocation(new ResourceLocation("chemlib", "element_liquid_model"), "inventory"));
        event.register((ResourceLocation)new ModelResourceLocation(new ResourceLocation("chemlib", "element_gas_model"), "inventory"));
        event.register((ResourceLocation)new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_dust_model"), "inventory"));
        event.register((ResourceLocation)new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_nugget_model"), "inventory"));
        event.register((ResourceLocation)new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_ingot_model"), "inventory"));
        event.register((ResourceLocation)new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_plate_model"), "inventory"));
    }
}

