/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.screen.HeartType;
import terrails.colorfulhearts.render.RenderUtils;

public class HeartColorEditBox
extends EditBox {
    private static final Pattern HEX_FORMAT = Pattern.compile("^#[0-9a-fA-F]{0,6}$");
    private static final Pattern HEX_MATCH = Pattern.compile("^#[0-9a-fA-F]{6}$");
    private boolean invalidHex = true;
    private final HeartType type;

    public HeartColorEditBox(Font font, int x, int y, int width, int height, HeartType type) {
        this(font, x, y, width, height, null, type);
    }

    public HeartColorEditBox(Font font, int x, int y, int width, int height, @Nullable EditBox editBox, HeartType type) {
        super(font, x, y, width, height, editBox, (Component)Component.m_237119_());
        this.type = type;
        this.m_94151_(str -> {});
        this.m_94153_(str -> HEX_FORMAT.matcher((CharSequence)str).matches());
        this.m_94199_(7);
        if (editBox != null) {
            this.m_94144_(editBox.m_94155_());
        }
    }

    public boolean isInvalidHex() {
        return this.invalidHex;
    }

    public int getColor() {
        return Integer.decode(this.m_94155_()) & 0xFFFFFF;
    }

    public void m_94151_(@NotNull Consumer<String> responder) {
        super.m_94151_(str -> {
            this.invalidHex = !HEX_MATCH.matcher((CharSequence)str).matches();
            responder.accept((String)str);
        });
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.m_94213_()) {
            return;
        }
        if (this.isInvalidHex()) {
            boolean isBordered;
            boolean bl = isBordered = this.m_94210_() < this.f_93618_;
            if (isBordered) {
                int borderColor = this.m_93696_() ? -2743526 : -10942713;
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_(), borderColor);
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() + this.f_93619_, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, borderColor);
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_(), this.m_252754_(), this.m_252907_() + this.f_93619_, borderColor);
                guiGraphics.m_280509_(this.m_252754_() + this.f_93618_, this.m_252907_(), this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_, borderColor);
            }
        } else {
            int x = this.m_252754_() + this.f_93618_ - 11;
            int y = this.m_252907_() + this.f_93619_ / 2 - 4;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(this.type.isHealthType() ? CColorfulHearts.HEALTH_ICONS_LOCATION : CColorfulHearts.ABSORPTION_ICONS_LOCATION));
            int texX = 0;
            switch (this.type) {
                case HEALTH_POISONED: 
                case ABSORBING_POISONED: {
                    texX += 18;
                    break;
                }
                case HEALTH_WITHERED: 
                case ABSORBING_WITHERED: {
                    texX += 36;
                    break;
                }
                case HEALTH_FROZEN: 
                case ABSORBING_FROZEN: {
                    texX += 54;
                }
            }
            int texY = 0;
            RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY, this.getColor(), 255);
            RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
            RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
        }
    }
}

