/*
 * Decompiled with CFR 0.152.
 */
package lykrast.glassential;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lykrast.glassential.blocks.DarkEtherealGlassBlock;
import lykrast.glassential.blocks.DarkGlassBlock;
import lykrast.glassential.blocks.EtherealGlassBlock;
import lykrast.glassential.blocks.MagmaEtherealGlassBlock;
import lykrast.glassential.blocks.MagmaGlassBlock;
import lykrast.glassential.blocks.RedstoneGlassBlock;
import lykrast.glassential.blocks.TooltipGlassBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="glassential")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="glassential")
public class Glassential {
    public static final String MODID = "glassential";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"glassential");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"glassential");
    private static List<RegistryObject<Item>> itemsForCreative = new ArrayList<RegistryObject<Item>>();
    private static RegistryObject<Item> stackForIcon;
    private static final String GHOSTLY = "tooltip.glassential.ghostly";
    private static final String LIGHT = "tooltip.glassential.light";
    private static final String OBSIDIAN = "tooltip.glassential.obsidian";

    public Glassential() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        bus.addListener(Glassential::makeCreativeTab);
    }

    public static void makeCreativeTab(RegisterEvent event) {
        event.register(Registries.f_279569_, helper -> helper.register(ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation(MODID, MODID)), (Object)CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.glassential.items")).m_257737_(() -> new ItemStack((ItemLike)stackForIcon.get())).m_257501_((parameters, output) -> itemsForCreative.forEach(i -> output.m_246326_((ItemLike)i.get()))).m_257652_()));
    }

    private static RegistryObject<Block> makeBlock(String name, Supplier<Block> block) {
        RegistryObject regged = BLOCKS.register(name, block);
        itemsForCreative.add((RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)regged.get(), new Item.Properties())));
        if (name.equals("glass_ethereal_reverse")) {
            stackForIcon = itemsForCreative.get(itemsForCreative.size() - 1);
        }
        return regged;
    }

    private static BlockBehaviour.Properties glassProp() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60922_(Glassential::neverAllowSpawn).m_60924_(Glassential::isntSolid).m_60960_(Glassential::isntSolid).m_60971_(Glassential::isntSolid);
    }

    private static BlockBehaviour.Properties ghostProp() {
        return Glassential.glassProp().m_280606_().m_60910_();
    }

    private static BlockBehaviour.Properties obsidian() {
        return Glassential.glassProp().m_60913_(0.5f, 1200.0f);
    }

    private static BlockBehaviour.Properties ghostbsidian() {
        return Glassential.ghostProp().m_60913_(0.5f, 1200.0f);
    }

    private static Boolean neverAllowSpawn(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    static {
        Glassential.makeBlock("glass_redstone", () -> new RedstoneGlassBlock(Glassential.glassProp()));
        Glassential.makeBlock("glass_ghostly", () -> new TooltipGlassBlock(Glassential.ghostProp(), GHOSTLY));
        Glassential.makeBlock("glass_ethereal", () -> new EtherealGlassBlock(Glassential.ghostProp(), false));
        Glassential.makeBlock("glass_ethereal_reverse", () -> new EtherealGlassBlock(Glassential.ghostProp(), true));
        Glassential.makeBlock("glass_dark_ghostly", () -> new DarkGlassBlock(Glassential.ghostProp(), GHOSTLY));
        Glassential.makeBlock("glass_dark_ethereal", () -> new DarkEtherealGlassBlock(Glassential.ghostProp(), false));
        Glassential.makeBlock("glass_dark_ethereal_reverse", () -> new DarkEtherealGlassBlock(Glassential.ghostProp(), true));
        Glassential.makeBlock("glass_light", () -> new TooltipGlassBlock(Glassential.glassProp().m_60953_(b -> 15), LIGHT));
        Glassential.makeBlock("glass_light_ghostly", () -> new TooltipGlassBlock(Glassential.ghostProp().m_60953_(b -> 15), GHOSTLY, LIGHT));
        Glassential.makeBlock("glass_light_ethereal", () -> new EtherealGlassBlock(Glassential.ghostProp().m_60953_(b -> 15), false, LIGHT));
        Glassential.makeBlock("glass_light_ethereal_reverse", () -> new EtherealGlassBlock(Glassential.ghostProp().m_60953_(b -> 15), true, LIGHT));
        Glassential.makeBlock("glass_magma", () -> new MagmaGlassBlock(Glassential.glassProp().m_60953_(b -> 3)));
        Glassential.makeBlock("glass_magma_ghostly", () -> new MagmaGlassBlock(Glassential.ghostProp().m_60953_(b -> 3), GHOSTLY));
        Glassential.makeBlock("glass_magma_ethereal", () -> new MagmaEtherealGlassBlock(Glassential.ghostProp().m_60953_(b -> 3), false));
        Glassential.makeBlock("glass_magma_ethereal_reverse", () -> new MagmaEtherealGlassBlock(Glassential.ghostProp().m_60953_(b -> 3), true));
        Glassential.makeBlock("glass_obsidian", () -> new TooltipGlassBlock(Glassential.obsidian(), OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_redstone", () -> new RedstoneGlassBlock(Glassential.obsidian(), OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_ghostly", () -> new TooltipGlassBlock(Glassential.ghostbsidian(), GHOSTLY));
        Glassential.makeBlock("glass_obsidian_ethereal", () -> new EtherealGlassBlock(Glassential.ghostbsidian(), false, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_ethereal_reverse", () -> new EtherealGlassBlock(Glassential.ghostbsidian(), true, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_dark", () -> new DarkGlassBlock(Glassential.obsidian(), null, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_dark_ghostly", () -> new DarkGlassBlock(Glassential.ghostbsidian(), GHOSTLY, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_dark_ethereal", () -> new DarkEtherealGlassBlock(Glassential.ghostbsidian(), false, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_dark_ethereal_reverse", () -> new DarkEtherealGlassBlock(Glassential.ghostbsidian(), true, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_light", () -> new TooltipGlassBlock(Glassential.obsidian().m_60953_(b -> 15), LIGHT, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_light_ghostly", () -> new TooltipGlassBlock(Glassential.ghostbsidian().m_60953_(b -> 15), GHOSTLY, LIGHT, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_light_ethereal", () -> new EtherealGlassBlock(Glassential.ghostbsidian().m_60953_(b -> 15), false, LIGHT, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_light_ethereal_reverse", () -> new EtherealGlassBlock(Glassential.ghostbsidian().m_60953_(b -> 15), true, LIGHT, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_magma", () -> new MagmaGlassBlock(Glassential.obsidian().m_60953_(b -> 3), null, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_magma_ghostly", () -> new MagmaGlassBlock(Glassential.ghostbsidian().m_60953_(b -> 3), GHOSTLY, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_magma_ethereal", () -> new MagmaEtherealGlassBlock(Glassential.ghostbsidian().m_60953_(b -> 3), false, OBSIDIAN));
        Glassential.makeBlock("glass_obsidian_magma_ethereal_reverse", () -> new MagmaEtherealGlassBlock(Glassential.ghostbsidian().m_60953_(b -> 3), true, OBSIDIAN));
    }
}

