/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.gateways.client.GatewaysClient;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.entity.NormalGatewayEntity;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.normal.NormalGateway;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class NormalGateClient {
    public static final ResourceLocation BARS = GatewaysClient.BARS;

    public static void appendPearlTooltip(NormalGateway gate, Level level, List<Component> tooltips, TooltipFlag flag) {
        List<Reward> rewards;
        List<MutableComponent> list;
        MutableComponent comp;
        int waveIdx = Math.floorMod(GatewaysClient.scrollIdx, gate.getNumWaves());
        Wave wave = gate.getWave(waveIdx);
        if (Screen.m_96638_()) {
            comp = Component.m_237110_((String)"tooltip.gateways.wave", (Object[])new Object[]{waveIdx + 1, gate.getNumWaves()}).m_130940_(ChatFormatting.GRAY);
            comp.m_7220_(CommonComponents.f_263701_);
            comp.m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.scroll").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131162_(Boolean.valueOf(false))));
            tooltips.add((Component)comp);
            comp = AttributeHelper.list().m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.entities").m_130948_(Style.f_131099_.m_178520_(8900331)));
            tooltips.add((Component)comp);
            for (WaveEntity waveEntity : wave.entities()) {
                comp = AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.dot", (Object[])new Object[]{waveEntity.getDescription()}).m_130948_(Style.f_131099_.m_178520_(8900331)));
                tooltips.add((Component)comp);
            }
            if (!wave.modifiers().isEmpty()) {
                comp = AttributeHelper.list().m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.modifiers").m_130940_(ChatFormatting.RED));
                tooltips.add((Component)comp);
                for (WaveModifier waveModifier : wave.modifiers()) {
                    waveModifier.appendHoverText(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.dot", (Object[])new Object[]{c.m_130940_(ChatFormatting.RED)}).m_130938_(s -> s.m_131140_(ChatFormatting.RED)))));
                }
            }
            comp = AttributeHelper.list().m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.rewards").m_130938_(s -> s.m_131140_(ChatFormatting.GOLD)));
            tooltips.add((Component)comp);
            for (Reward reward : wave.rewards()) {
                reward.appendHoverText(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.dot", (Object[])new Object[]{c}).m_130938_(s -> s.m_131140_(ChatFormatting.GOLD)))));
            }
        } else {
            comp = Component.m_237110_((String)("tooltip.gateways.num_wave" + (gate.getNumWaves() == 1 ? "" : "s")), (Object[])new Object[]{gate.getNumWaves()}).m_130940_(ChatFormatting.GRAY);
            comp.m_7220_(CommonComponents.f_263701_);
            comp.m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.shift").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
            tooltips.add((Component)comp);
        }
        List<Failure> failures = gate.failures();
        if (!failures.isEmpty()) {
            if (Screen.m_96637_()) {
                comp = Component.m_237115_((String)"tooltip.gateways.failures").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                tooltips.add((Component)comp);
                for (Failure f : failures) {
                    f.appendHoverText(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)c.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)))));
                }
            } else {
                comp = Component.m_237110_((String)("tooltip.gateways.num_failure" + (failures.size() == 1 ? "" : "s")), (Object[])new Object[]{failures.size()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                comp.m_7220_(CommonComponents.f_263701_);
                comp.m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.ctrl").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
                tooltips.add((Component)comp);
            }
        }
        if (!(list = gate.rules().buildDeviations()).isEmpty()) {
            if (Screen.m_96639_()) {
                comp = Component.m_237110_((String)"tooltip.gateways.rules", (Object[])new Object[]{list.size()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
                tooltips.add((Component)comp);
                list.forEach(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)c.m_130940_(ChatFormatting.DARK_GREEN))));
            } else {
                comp = Component.m_237110_((String)("tooltip.gateways.num_rule" + (list.size() == 1 ? "" : "s")), (Object[])new Object[]{list.size()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
                comp.m_7220_(CommonComponents.f_263701_);
                comp.m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.alt").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
                tooltips.add((Component)comp);
            }
        }
        if (!(rewards = gate.rewards()).isEmpty()) {
            comp = Component.m_237115_((String)"tooltip.gateways.key_rewards").m_130948_(Style.f_131099_.m_178520_(3385888));
            tooltips.add((Component)comp);
            for (Reward r : rewards) {
                r.appendHoverText(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)c.m_130948_(Style.f_131099_.m_178520_(3385888)))));
            }
        }
    }

    public static void renderBossBar(GatewayEntity gateEntity, Object guiGfx, int x, int y, boolean isInWorld) {
        int i;
        NormalGatewayEntity gate = (NormalGatewayEntity)gateEntity;
        GuiGraphics gfx = (GuiGraphics)guiGfx;
        PoseStack pose = gfx.m_280168_();
        int color = gate.getGateway().color().m_131265_();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        int wave = gate.getWave() + 1;
        int maxWave = gate.getGateway().getNumWaves();
        int enemies = gate.getActiveEnemies();
        int maxEnemies = gate.getCurrentWave().entities().stream().mapToInt(WaveEntity::getCount).sum();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int y2 = y + 10 + 9;
        pose.m_85836_();
        pose.m_85837_(0.0, 0.0, 0.01);
        gfx.m_280163_(BARS, x, y, 0.0f, 60.0f, 182, 5, 256, 256);
        gfx.m_280163_(BARS, x, y2, 0.0f, 60.0f, 182, 5, 256, 256);
        pose.m_85849_();
        float waveProgress = 1.0f / (float)maxWave;
        float progress = waveProgress * (float)(maxWave - wave + 1);
        if (gate.isWaveActive()) {
            progress -= waveProgress * ((float)(maxEnemies - enemies) / (float)maxEnemies);
        }
        if ((i = (int)(progress * 183.0f)) > 0) {
            gfx.m_280163_(BARS, x, y, 0.0f, 65.0f, i, 5, 256, 256);
        }
        float maxTime = gate.getMaxWaveTime();
        if (gate.isWaveActive()) {
            i = (int)((maxTime - (float)gate.getTicksActive()) / maxTime * 183.0f);
            if (i > 0) {
                gfx.m_280163_(BARS, x, y2, 0.0f, 65.0f, i, 5, 256, 256);
            }
        } else {
            maxTime = gate.getSetupTime();
            i = (int)((float)gate.getTicksActive() / maxTime * 183.0f);
            if (i > 0) {
                gfx.m_280163_(BARS, x, y2, 0.0f, 65.0f, i, 5, 256, 256);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent component = Component.m_237113_((String)gate.m_7770_().getString()).m_130940_(ChatFormatting.GOLD);
        int strWidth = font.m_92852_((FormattedText)component);
        int textX = x + 91 - strWidth / 2;
        int textY = y - 9;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.m_280614_(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
        textY = y2 - 9;
        int time = (int)maxTime - gate.getTicksActive();
        String str = I18n.m_118938_((String)"boss.gateways.wave", (Object[])new Object[]{wave, maxWave, StringUtil.m_14404_((int)time), enemies});
        if (!gate.isWaveActive()) {
            str = gate.isLastWave() ? I18n.m_118938_((String)"boss.gateways.done", (Object[])new Object[0]) : I18n.m_118938_((String)"boss.gateways.starting", (Object[])new Object[]{wave, StringUtil.m_14404_((int)time)});
        }
        component = Component.m_237113_((String)str).m_130940_(ChatFormatting.GREEN);
        strWidth = font.m_92852_((FormattedText)component);
        textX = x + 91 - strWidth / 2;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.m_280614_(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
    }
}

