/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Stairs
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.m_61587_((String)"connection", ConnectionStatus.class);
    public static final VoxelShape N = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape E = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape S = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape W = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));

    public Bridge_Stairs(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    private BlockState StairState(BlockState state, LevelAccessor access, BlockPos pos) {
        BlockState northState = access.m_8055_(pos.m_122012_());
        BlockState eastState = access.m_8055_(pos.m_122029_());
        BlockState southState = access.m_8055_(pos.m_122019_());
        BlockState westState = access.m_8055_(pos.m_122024_());
        boolean north = northState.m_60734_() == this;
        boolean east = eastState.m_60734_() == this;
        boolean south = southState.m_60734_() == this;
        boolean west = westState.m_60734_() == this;
        ConnectionStatus connection = this.getConnectionStatus((Direction)state.m_61143_((Property)FACING), north, east, south, west);
        return (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        boolean isConnectedNorthSouth = north && south;
        boolean isConnectedEastWest = east && west;
        switch (facing) {
            case NORTH: {
                if (isConnectedNorthSouth) {
                    return ConnectionStatus.DOUBLE;
                }
                if (south) {
                    return ConnectionStatus.RIGHT;
                }
                if (north) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case SOUTH: {
                if (isConnectedNorthSouth) {
                    return ConnectionStatus.DOUBLE;
                }
                if (north) {
                    return ConnectionStatus.RIGHT;
                }
                if (south) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case EAST: {
                if (isConnectedEastWest) {
                    return ConnectionStatus.DOUBLE;
                }
                if (west) {
                    return ConnectionStatus.RIGHT;
                }
                if (east) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case WEST: {
                if (isConnectedEastWest) {
                    return ConnectionStatus.DOUBLE;
                }
                if (east) {
                    return ConnectionStatus.RIGHT;
                }
                if (west) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
        }
        return ConnectionStatus.BASE;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return this.StairState(state, access, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return N;
            }
            case SOUTH: {
                return S;
            }
            case WEST: {
                return W;
            }
        }
        return E;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockItem blockItem;
        ItemStack itemstack = player.m_21120_(handIn);
        if (itemstack.m_41720_() instanceof BlockItem && (blockItem = (BlockItem)itemstack.m_41720_()).m_40614_() == this) {
            Direction blockFacingDirection = (Direction)state.m_61143_((Property)FACING);
            Direction facing = player.m_6350_();
            BlockPos placePos = pos.m_121945_(facing).m_7494_();
            if (level.m_8055_(placePos).m_60795_()) {
                level.m_7731_(placePos, (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockFacingDirection), 3);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext contx) {
        BlockPos pos = contx.m_8083_().m_7495_();
        Level world = contx.m_43725_();
        BlockState stateBelow = world.m_8055_(pos);
        if (stateBelow.m_60734_() instanceof Bridge_Stairs) {
            return null;
        }
        return (BlockState)this.StairState(super.m_5573_(contx), (LevelAccessor)contx.m_43725_(), contx.m_8083_()).m_61124_((Property)FACING, (Comparable)contx.m_8125_().m_122427_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CONNECTION});
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        BASE("base"),
        DOUBLE("double"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

