/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.capability.FluxPlayer;

public class FluxPlayerProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final ResourceLocation CAP_KEY = FluxNetworks.location("flux_player");
    @Nonnull
    private final FluxPlayer mCap = new FluxPlayer();
    private final LazyOptional<FluxPlayer> mHandler = LazyOptional.of(() -> this.mCap);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return FluxPlayer.FLUX_PLAYER.orEmpty(cap, this.mHandler);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.mCap.writeNBT(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.mCap.readNBT(nbt);
    }
}

