/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.mixin;

import dev.shadowsoffire.placebo.events.PlaceboEventFactory;
import dev.shadowsoffire.placebo.util.CachedObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin
implements CachedObject.CachedObjectSource {
    private volatile Map<ResourceLocation, CachedObject<?>> cachedObjects = null;

    @Inject(at={@At(value="HEAD")}, method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, cancellable=true, require=1)
    public void placebo_itemUseHook(UseOnContext ctx, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult itemUseEventRes = PlaceboEventFactory.onItemUse((ItemStack)this, ctx);
        if (itemUseEventRes != null) {
            cir.setReturnValue((Object)itemUseEventRes);
        }
    }

    @Override
    public <T> T getOrCreate(ResourceLocation id, Function<ItemStack, T> deserializer, ToIntFunction<ItemStack> hasher) {
        CachedObject cachedObj = this.getOrCreate().computeIfAbsent(id, key -> new CachedObject((ResourceLocation)key, deserializer, hasher));
        return cachedObj.get((ItemStack)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ResourceLocation, CachedObject<?>> getOrCreate() {
        if (this.cachedObjects == null) {
            ItemStackMixin itemStackMixin = this;
            synchronized (itemStackMixin) {
                if (this.cachedObjects == null) {
                    this.cachedObjects = new ConcurrentHashMap();
                }
            }
        }
        return this.cachedObjects;
    }
}

