/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.CompressedBlockPosSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public record LabelPositionHolder(Map<String, HashSet<BlockPos>> labels) {
    private static final WeakHashMap<ItemStack, LabelPositionHolder> CACHE = new WeakHashMap();

    private LabelPositionHolder() {
        this(new HashMap<String, HashSet<BlockPos>>());
    }

    private LabelPositionHolder(LabelPositionHolder other) {
        this();
        other.labels().forEach((? super K key, ? super V value) -> this.labels().put((String)key, new HashSet(value)));
    }

    public static LabelPositionHolder from(ItemStack stack) {
        return CACHE.computeIfAbsent(stack, s -> {
            CompoundTag tag = stack.m_41784_().m_128469_("sfm:labels");
            return LabelPositionHolder.deserialize(tag);
        });
    }

    public static LabelPositionHolder empty() {
        return new LabelPositionHolder();
    }

    public static LabelPositionHolder deserialize(CompoundTag tag) {
        LabelPositionHolder labels = LabelPositionHolder.empty();
        for (String label : tag.m_128431_()) {
            Tag positionsTag = tag.m_128423_(label);
            assert (positionsTag != null);
            byte positionsTagType = tag.m_128435_(label);
            if (positionsTagType == 9) {
                ListTag positionsList = (ListTag)positionsTag;
                byte elementType = positionsList.m_7264_();
                if (elementType == 4) {
                    labels.addAll(label, positionsList.stream().map(LongTag.class::cast).mapToLong(LongTag::m_7046_).mapToObj(BlockPos::m_122022_).collect(Collectors.toList()));
                    continue;
                }
                if (elementType != 10) continue;
                labels.addAll(label, positionsList.stream().map(CompoundTag.class::cast).map(NbtUtils::m_129239_).collect(Collectors.toList()));
                continue;
            }
            if (positionsTagType != 7) continue;
            labels.addAll(label, CompressedBlockPosSet.from((ByteArrayTag)positionsTag).into());
        }
        return labels;
    }

    public LabelPositionHolder save(ItemStack stack) {
        stack.m_41784_().m_128365_("sfm:labels", (Tag)this.serialize());
        CACHE.put(stack, new LabelPositionHolder(this));
        return this;
    }

    public static void clear(ItemStack stack) {
        stack.m_41784_().m_128473_("sfm:labels");
        CACHE.remove(stack);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, HashSet<BlockPos>> entry : this.labels().entrySet()) {
            String label = entry.getKey();
            ByteArrayTag positionsTag = CompressedBlockPosSet.from((Set<BlockPos>)entry.getValue()).asTag();
            tag.m_128365_(label, (Tag)positionsTag);
        }
        return tag;
    }

    public boolean contains(String label, BlockPos pos) {
        HashSet<BlockPos> positionsForLabel = this.labels().get(label);
        if (positionsForLabel == null) {
            return false;
        }
        return positionsForLabel.contains(pos);
    }

    public LabelPositionHolder toggle(String label, BlockPos pos) {
        if (this.contains(label, pos)) {
            this.remove(label, pos);
        } else {
            this.add(label, pos);
        }
        return this;
    }

    public Set<BlockPos> getPositions(String label) {
        return this.labels().getOrDefault(label, new HashSet());
    }

    public Set<BlockPos> getPositionsMut(String label) {
        return this.labels().computeIfAbsent(label, s -> new HashSet());
    }

    public LabelPositionHolder addAll(String label, Collection<BlockPos> positions) {
        this.getPositionsMut(label).addAll(positions);
        return this;
    }

    public LabelPositionHolder addReferencedLabel(String label) {
        this.getPositionsMut(label);
        return this;
    }

    public List<Component> asHoverText() {
        ArrayList<Component> rtn = new ArrayList<Component>();
        if (this.labels().isEmpty()) {
            return rtn;
        }
        rtn.add((Component)LocalizationKeys.DISK_ITEM_TOOLTIP_LABEL_HEADER.getComponent().m_130940_(ChatFormatting.UNDERLINE));
        for (Map.Entry<String, HashSet<BlockPos>> entry : this.labels().entrySet()) {
            rtn.add((Component)LocalizationKeys.DISK_ITEM_TOOLTIP_LABEL.getComponent(entry.getKey(), entry.getValue().size()).m_130940_(ChatFormatting.GRAY));
        }
        return rtn;
    }

    public LabelPositionHolder removeAll(BlockPos value) {
        this.labels().values().forEach((? super T list) -> list.remove(value));
        return this;
    }

    public LabelPositionHolder prune() {
        this.labels().entrySet().removeIf((? super E entry) -> ((HashSet)entry.getValue()).isEmpty());
        return this;
    }

    public LabelPositionHolder clear() {
        this.labels().clear();
        return this;
    }

    public LabelPositionHolder add(String label, BlockPos position) {
        this.getPositionsMut(label).add(position);
        return this;
    }

    public LabelPositionHolder remove(String label, BlockPos pos) {
        this.getPositionsMut(label).remove(pos);
        return this;
    }

    public LabelPositionHolder removeIf(BiPredicate<String, BlockPos> predicate) {
        this.labels().forEach((? super K key, ? super V value) -> value.removeIf((? super E pos) -> predicate.test((String)key, (BlockPos)pos)));
        return this;
    }

    public LabelPositionHolder removeIf(Predicate<String> predicate) {
        this.labels().keySet().removeIf(predicate);
        return this;
    }

    public LabelPositionHolder forEach(BiConsumer<String, BlockPos> consumer) {
        this.labels().forEach((? super K key, ? super V value) -> value.forEach((? super T pos) -> consumer.accept((String)key, (BlockPos)pos)));
        return this;
    }

    @Override
    public String toString() {
        return "LabelPositionHolder{size=" + this.labels().values().stream().mapToInt(Set::size).sum() + "; " + this.labels().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + ((HashSet)entry.getValue()).size()).collect(Collectors.joining(", ")) + "}";
    }

    public LabelPositionHolder toOwned() {
        return new LabelPositionHolder(this);
    }

    public Set<String> getLabels(BlockPos pos) {
        return this.labels().entrySet().stream().filter(entry -> ((HashSet)entry.getValue()).contains(pos)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.labels().isEmpty();
    }
}

