/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.client.gui.screen.SFMScreenUtils;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.item.NetworkToolItem;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.util.HelpsWithMinecraftVersionIndependence;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ItemWorldRenderer {
    private static final int BUFFER_SIZE = 256;
    private static final RenderType RENDER_TYPE = RenderType.m_173215_((String)"sfm_overlay", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118259_, false, false)).m_110663_(new RenderStateShard.DepthTestStateShard("always", 519)).m_110685_(new RenderStateShard.TransparencyStateShard("src_to_one", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).m_110691_(true));
    private static final int capabilityColor = FastColor.ARGB32.m_13660_((int)100, (int)100, (int)0, (int)255);
    private static final int capabilityColorLimitedView = FastColor.ARGB32.m_13660_((int)100, (int)0, (int)100, (int)255);
    private static final int cableColor = FastColor.ARGB32.m_13660_((int)100, (int)100, (int)255, (int)0);
    private static final VBOCache vboCache = new VBOCache();

    @SubscribeEvent
    public static void renderOverlays(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Camera camera = minecraft.f_91063_.m_109153_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        boolean rendered = false;
        ItemStack held = ItemWorldRenderer.getHeldItemOfType(player, NetworkToolItem.class);
        if (held != null) {
            ItemWorldRenderer.handleNetworkTool(event, poseStack, camera, bufferSource, held);
            rendered = true;
        }
        if ((held = ItemWorldRenderer.getHeldItemOfType(player, LabelGunItem.class)) != null) {
            ItemWorldRenderer.handleLabelGun(event, poseStack, camera, bufferSource, held);
            rendered = true;
        }
        if (!rendered) {
            vboCache.clear();
        }
    }

    @Nullable
    public static BlockPos lookingAt() {
        HitResult rt = Minecraft.m_91087_().f_91077_;
        if (rt == null) {
            return null;
        }
        double x = rt.m_82450_().f_82479_;
        double y = rt.m_82450_().f_82480_;
        double z = rt.m_82450_().f_82481_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        assert (player != null);
        Vec3 lookAngle = player.m_20154_();
        double xla = lookAngle.f_82479_;
        double yla = lookAngle.f_82480_;
        double zla = lookAngle.f_82481_;
        if (x % 1.0 == 0.0 && xla < 0.0) {
            x -= 0.01;
        }
        if (y % 1.0 == 0.0 && yla < 0.0) {
            y -= 0.01;
        }
        if (z % 1.0 == 0.0 && zla < 0.0) {
            z -= 0.01;
        }
        return new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    @Nullable
    private static ItemStack getHeldItemOfType(LocalPlayer player, Class<?> itemClass) {
        ItemStack mainHandItem = player.m_21205_();
        if (itemClass.isInstance(mainHandItem.m_41720_())) {
            return mainHandItem;
        }
        ItemStack offhandItem = player.m_21206_();
        if (itemClass.isInstance(offhandItem.m_41720_())) {
            return offhandItem;
        }
        return null;
    }

    private static void handleLabelGun(RenderLevelStageEvent event, PoseStack poseStack, Camera camera, MultiBufferSource.BufferSource bufferSource, ItemStack labelGun) {
        LabelGunItem.LabelGunViewMode viewMode = LabelGunItem.getViewMode(labelGun);
        LabelPositionHolder labelPositionHolder = LabelPositionHolder.from(labelGun);
        HashMultimap labelsByPosition = HashMultimap.create();
        String activeLabel = LabelGunItem.getActiveLabel(labelGun);
        BlockPos lookingAtPos = ItemWorldRenderer.lookingAt();
        switch (viewMode) {
            case SHOW_ALL: {
                labelPositionHolder.forEach((label, pos) -> labelsByPosition.put(pos, label));
                break;
            }
            case SHOW_ONLY_ACTIVE_LABEL_AND_TARGETED_BLOCK: {
                if (!activeLabel.isEmpty()) {
                    labelPositionHolder.forEach((label, pos) -> {
                        if (label.equals(activeLabel)) {
                            labelsByPosition.put(pos, label);
                        }
                    });
                }
                if (lookingAtPos == null) break;
                for (String string : labelPositionHolder.getLabels(lookingAtPos)) {
                    labelsByPosition.put((Object)lookingAtPos, (Object)string);
                }
                break;
            }
            case SHOW_ONLY_TARGETED_BLOCK: {
                if (lookingAtPos == null) break;
                for (String string : labelPositionHolder.getLabels(lookingAtPos)) {
                    labelsByPosition.put((Object)lookingAtPos, (Object)string);
                }
                break;
            }
        }
        RenderSystem.disableDepthTest();
        poseStack.m_85836_();
        poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
        for (Map.Entry entry : labelsByPosition.asMap().entrySet()) {
            BlockPos pos2 = (BlockPos)entry.getKey();
            Collection labels = (Collection)entry.getValue();
            ItemWorldRenderer.drawLabelsForPos(poseStack, camera, pos2, (MultiBufferSource)bufferSource, labels);
        }
        poseStack.m_85849_();
        RENDER_TYPE.m_110185_();
        Set labelledPositions = labelsByPosition.keySet();
        ItemWorldRenderer.drawVbo(VBOKind.LABEL_GUN_CAPABILITIES, poseStack, labelledPositions, viewMode != LabelGunItem.LabelGunViewMode.SHOW_ALL ? capabilityColorLimitedView : capabilityColor, event);
        RENDER_TYPE.m_110188_();
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
    }

    private static void handleNetworkTool(RenderLevelStageEvent event, PoseStack poseStack, Camera ignoredCamera, MultiBufferSource.BufferSource bufferSource, ItemStack networkTool) {
        if (!NetworkToolItem.getOverlayEnabled(networkTool)) {
            return;
        }
        Set<BlockPos> cablePositions = NetworkToolItem.getCablePositions(networkTool);
        Set<BlockPos> capabilityPositions = NetworkToolItem.getCapabilityProviderPositions(networkTool);
        RenderSystem.disableDepthTest();
        RENDER_TYPE.m_110185_();
        ItemWorldRenderer.drawVbo(VBOKind.NETWORK_TOOL_CABLES, poseStack, cablePositions, cableColor, event);
        ItemWorldRenderer.drawVbo(VBOKind.NETWORK_TOOL_CAPABILITIES, poseStack, capabilityPositions, capabilityColor, event);
        RENDER_TYPE.m_110188_();
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
    }

    private static void drawVbo(VBOKind vboKind, PoseStack poseStack, Set<BlockPos> positions, int color, RenderLevelStageEvent event) {
        VertexBuffer vbo = vboCache.getVBO(vboKind, positions, event, FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), FastColor.ARGB32.m_13655_((int)color));
        if (vbo != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(-event.getCamera().m_90583_().f_82479_, -event.getCamera().m_90583_().f_82480_, -event.getCamera().m_90583_().f_82481_);
            vbo.m_85921_();
            assert (GameRenderer.m_172811_() != null);
            vbo.m_253207_(poseStack.m_85850_().m_252922_(), event.getProjectionMatrix(), GameRenderer.m_172811_());
            VertexBuffer.m_85931_();
            poseStack.m_85849_();
        }
    }

    private static void drawLabelsForPos(PoseStack poseStack, Camera camera, @NotStored BlockPos pos, MultiBufferSource mbs, Collection<String> labels) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Font font = Minecraft.m_91087_().f_91062_;
        double d = labels.size();
        Objects.requireNonNull(font);
        poseStack.m_85837_(0.0, d * (9.0 + 0.1) / -2.0, 0.0);
        for (String label : labels) {
            SFMScreenUtils.drawInBatch(label, font, (float)(-font.m_92895_(label)) / 2.0f, 0.0f, false, poseStack.m_85850_().m_252922_(), mbs, true);
            Objects.requireNonNull(font);
            poseStack.m_85837_(0.0, 9.0 + 0.1, 0.0);
        }
        poseStack.m_85849_();
    }

    @HelpsWithMinecraftVersionIndependence
    private static void writeVertex(VertexConsumer builder, Matrix4f matrix4f, float x, float y, float z, int r, int g, int b, int a) {
        builder.m_252986_(matrix4f, x, y, z).m_6122_(r, g, b, a).m_5752_();
    }

    private static void writeFaceVertices(VertexConsumer builder, Matrix4f matrix4f, Direction direction, int r, int g, int b, int a) {
        double scale = 1.0 - (double)direction.ordinal() / 25.0;
        r = (int)((double)r * scale);
        g = (int)((double)g * scale);
        b = (int)((double)b * scale);
        a = (int)((double)a * scale);
        switch (direction) {
            case DOWN: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 1.0f, r, g, b, a);
                break;
            }
            case UP: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 0.0f, r, g, b, a);
                break;
            }
            case NORTH: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 0.0f, r, g, b, a);
                break;
            }
            case SOUTH: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 1.0f, r, g, b, a);
                break;
            }
            case WEST: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 0.0f, r, g, b, a);
                break;
            }
            case EAST: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 1.0f, r, g, b, a);
            }
        }
    }

    private static class VBOCache {
        private final EnumMap<VBOKind, VBOEntry> cache = new EnumMap(VBOKind.class);
        private int lastChangeCheck = -1;

        private VBOCache() {
        }

        @Nullable
        public VertexBuffer getVBO(VBOKind kind, Set<BlockPos> positions, RenderLevelStageEvent event, int r, int g, int b, int a) {
            boolean shouldRebuild;
            if (positions.isEmpty()) {
                return null;
            }
            @Nullable VBOEntry entry = this.cache.get((Object)kind);
            boolean bl = shouldRebuild = entry == null;
            if (entry != null && event.getRenderTick() != this.lastChangeCheck && !entry.positions.equals(positions)) {
                this.lastChangeCheck = event.getRenderTick();
                shouldRebuild = true;
            }
            if (shouldRebuild) {
                if (entry != null) {
                    entry.vbo.close();
                }
                VertexBuffer vbo = this.createVBO(positions, r, g, b, a);
                entry = new VBOEntry(new HashSet<BlockPos>(positions), vbo);
                this.cache.put(kind, entry);
            }
            return entry.vbo;
        }

        public void clear() {
            for (VBOEntry entry : this.cache.values()) {
                entry.vbo.close();
            }
            this.cache.clear();
        }

        @HelpsWithMinecraftVersionIndependence
        private BufferBuilder createBufferBuilder(int numPositions) {
            BufferBuilder bufferBuilder = new BufferBuilder(RENDER_TYPE.m_110507_() * numPositions);
            bufferBuilder.m_166779_(RENDER_TYPE.m_173186_(), RENDER_TYPE.m_110508_());
            return bufferBuilder;
        }

        private VertexBuffer createVBO(Set<BlockPos> positions, int r, int g, int b, int a) {
            PoseStack poseStack = new PoseStack();
            BufferBuilder bufferBuilder = this.createBufferBuilder(positions.size());
            for (BlockPos blockPos : positions) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_());
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                for (Direction face : SFMDirections.DIRECTIONS) {
                    if (positions.contains(blockPos.m_121945_(face))) continue;
                    ItemWorldRenderer.writeFaceVertices((VertexConsumer)bufferBuilder, matrix4f, face, r, g, b, a);
                }
                poseStack.m_85849_();
            }
            BufferBuilder.RenderedBuffer meshData = bufferBuilder.m_231175_();
            VertexBuffer vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vbo.m_85921_();
            vbo.m_231221_(meshData);
            VertexBuffer.m_85931_();
            return vbo;
        }

        private record VBOEntry(Set<BlockPos> positions, VertexBuffer vbo) {
        }
    }

    private static enum VBOKind {
        LABEL_GUN_CAPABILITIES,
        NETWORK_TOOL_CAPABILITIES,
        NETWORK_TOOL_CABLES;

    }
}

