/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.client.ClientRaycastHelpers;
import ca.teamdman.sfm.client.ClientScreenHelpers;
import ca.teamdman.sfm.client.gui.ButtonBuilder;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ContainerScreenInspectorHandler {
    private static boolean visible = false;
    @Nullable
    private static AbstractContainerScreen<?> lastScreen = null;
    private static final Button exportInspectorButton = new ButtonBuilder().setSize(100, 20).setPosition(5, 50).setText(LocalizationKeys.CONTAINER_INSPECTOR_SHOW_EXPORTS_BUTTON).setOnPress(button -> {
        BlockEntity lookBlockEntity = ClientRaycastHelpers.getLookBlockEntity();
        if (lastScreen != null && lookBlockEntity != null) {
            SFMPackets.sendToServer(new ServerboundContainerExportsInspectionRequestPacket(ContainerScreenInspectorHandler.lastScreen.m_6262_().f_38840_, lookBlockEntity.m_58899_()));
        }
    }).build();

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre event) {
        boolean shouldCapture = Minecraft.m_91087_().f_91080_ instanceof AbstractContainerScreen;
        if (shouldCapture && visible && exportInspectorButton.m_93680_(event.getMouseX(), event.getMouseY())) {
            exportInspectorButton.m_7435_(Minecraft.m_91087_().m_91106_());
            exportInspectorButton.m_5716_(event.getMouseX(), event.getMouseY());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGuiRender(ScreenEvent.Render.Post event) {
        if (!visible) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2;
            lastScreen = screen2 = (AbstractContainerScreen)screen;
            AbstractContainerMenu menu = screen2.m_6262_();
            int containerSlotCount = 0;
            int inventorySlotCount = 0;
            GuiGraphics graphics = event.getGuiGraphics();
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 350.0f);
            exportInspectorButton.m_88315_(graphics, event.getMouseX(), event.getMouseY(), event.getPartialTick());
            Font font = Minecraft.m_91087_().f_91062_;
            for (Slot slot : menu.f_38839_) {
                int colour;
                if (slot.f_40218_ instanceof Inventory) {
                    colour = ChatFormatting.YELLOW.m_126665_();
                    ++inventorySlotCount;
                } else {
                    colour = 4095;
                    ++containerSlotCount;
                }
                graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)Integer.toString(slot.getSlotIndex())), screen2.getGuiLeft() + slot.f_40220_, screen2.getGuiTop() + slot.f_40221_, colour, false);
            }
            MutableComponent notice = LocalizationKeys.CONTAINER_INSPECTOR_NOTICE.getComponent().m_130940_(ChatFormatting.GOLD);
            int offset = font.m_92852_((FormattedText)notice) / 2;
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)notice, screen2.f_96543_ / 2 - offset, 5, 0xFFFFFF, true);
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)LocalizationKeys.CONTAINER_INSPECTOR_CONTAINER_SLOT_COUNT.getComponent(Component.m_237113_((String)String.valueOf(containerSlotCount)).m_130940_(ChatFormatting.BLUE)), 5, 25, 0xFFFFFF, true);
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)LocalizationKeys.CONTAINER_INSPECTOR_INVENTORY_SLOT_COUNT.getComponent(Component.m_237113_((String)String.valueOf(inventorySlotCount)).m_130940_(ChatFormatting.YELLOW)), 5, 40, 0xFFFFFF, true);
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public static void onKeyDown(ScreenEvent.KeyPressed.Pre event) {
        Screen screen;
        KeyMapping toggleKey = (KeyMapping)SFMKeyMappings.CONTAINER_INSPECTOR_KEY.get();
        boolean toggleKeyPressed = toggleKey.isActiveAndMatches(InputConstants.Type.KEYSYM.m_84895_(event.getKeyCode()));
        if (toggleKeyPressed) {
            visible = !visible;
            event.setCanceled(true);
            return;
        }
        KeyMapping activateKey = (KeyMapping)SFMKeyMappings.ITEM_INSPECTOR_KEY.get();
        boolean activateKeyPressed = activateKey.isActiveAndMatches(InputConstants.Type.KEYSYM.m_84895_(event.getKeyCode()));
        if (activateKeyPressed && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
            ItemStack hoveredStack;
            AbstractContainerScreen acs = (AbstractContainerScreen)screen;
            Slot hoveredSlot = acs.f_97734_;
            if (hoveredSlot != null && !(hoveredStack = hoveredSlot.m_7993_()).m_41619_()) {
                ClientScreenHelpers.showItemInspectorScreen(hoveredStack);
            }
        }
    }
}

