/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.MenuBuilder;
import noobanidus.mods.lootr.api.inventory.ILootrInventory;
import noobanidus.mods.lootr.data.ChestData;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import org.jetbrains.annotations.Nullable;

public class SpecialChestInventory
implements ILootrInventory {
    private final Component name;
    private final ChestData newChestData;
    private NonNullList<ItemStack> contents;
    private MenuBuilder menuBuilder = null;

    public SpecialChestInventory(ChestData newChestData, NonNullList<ItemStack> contents, Component name) {
        this.newChestData = newChestData;
        this.contents = !contents.isEmpty() ? contents : NonNullList.m_122780_((int)newChestData.getSize(), (Object)ItemStack.f_41583_);
        this.name = name;
    }

    public SpecialChestInventory(ChestData newChestData, CompoundTag items, String componentAsJSON) {
        this.newChestData = newChestData;
        this.name = Component.Serializer.m_130701_((String)componentAsJSON);
        this.contents = NonNullList.m_122780_((int)newChestData.getSize(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)items, this.contents);
    }

    public void setMenuBuilder(MenuBuilder builder) {
        this.menuBuilder = builder;
    }

    @Override
    @javax.annotation.Nullable
    public BaseContainerBlockEntity getBlockEntity(Level level) {
        if (level == null || level.m_5776_() || this.newChestData.getPos() == null) {
            return null;
        }
        BlockEntity te = level.m_7702_(this.newChestData.getPos());
        if (te instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity be = (BaseContainerBlockEntity)te;
            return be;
        }
        return null;
    }

    @Override
    @javax.annotation.Nullable
    public LootrChestMinecartEntity getEntity(Level world) {
        if (world == null || world.m_5776_() || this.newChestData.getEntityId() == null) {
            return null;
        }
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Entity entity = serverWorld.m_8791_(this.newChestData.getEntityId());
        if (entity instanceof LootrChestMinecartEntity) {
            return (LootrChestMinecartEntity)entity;
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos getPos() {
        return this.newChestData.getPos();
    }

    public int m_6643_() {
        return this.contents.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.contents, (int)index, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack result = ContainerHelper.m_18966_(this.contents, (int)index);
        if (!result.m_41619_()) {
            this.m_6596_();
        }
        return result;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.contents.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_6596_() {
        this.newChestData.m_77762_();
    }

    public boolean m_6542_(Player player) {
        if (!player.m_9236_().m_46472_().equals(this.newChestData.getDimension())) {
            return false;
        }
        if (this.newChestData.isEntity()) {
            if (this.newChestData.getEntityId() == null) {
                return false;
            }
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entity = serverLevel.m_8791_(this.newChestData.getEntityId());
                if (entity instanceof ContainerEntity) {
                    ContainerEntity container = (ContainerEntity)entity;
                    return container.m_219954_(player);
                }
                return false;
            }
            return true;
        }
        BlockEntity be = player.m_9236_().m_7702_(this.newChestData.getPos());
        if (be == null) {
            return false;
        }
        return Container.m_272074_((BlockEntity)be, (Player)player);
    }

    public void m_6211_() {
        this.contents.clear();
        this.m_6596_();
    }

    public Component m_5446_() {
        return this.name;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        if (this.menuBuilder != null) {
            return this.menuBuilder.build(id, inventory, this, this.m_6643_() / 9);
        }
        return switch (this.m_6643_()) {
            case 9 -> new ChestMenu(MenuType.f_39957_, id, inventory, (Container)this, 1);
            case 18 -> new ChestMenu(MenuType.f_39958_, id, inventory, (Container)this, 2);
            case 36 -> new ChestMenu(MenuType.f_39960_, id, inventory, (Container)this, 4);
            case 45 -> new ChestMenu(MenuType.f_39961_, id, inventory, (Container)this, 5);
            case 54 -> ChestMenu.m_39246_((int)id, (Inventory)inventory, (Container)this);
            default -> ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)this);
        };
    }

    public void m_5856_(Player player) {
        LootrChestMinecartEntity entity;
        Level world = player.m_9236_();
        BaseContainerBlockEntity tile = this.getBlockEntity(world);
        if (tile != null) {
            tile.m_5856_(player);
        }
        if (this.newChestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.m_5856_(player);
        }
    }

    public void m_5785_(Player player) {
        LootrChestMinecartEntity entity;
        BaseContainerBlockEntity tile;
        this.m_6596_();
        Level world = player.m_9236_();
        if (this.newChestData.getPos() != null && (tile = this.getBlockEntity(world)) != null) {
            tile.m_5785_(player);
        }
        if (this.newChestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.m_5785_(player);
        }
    }

    @javax.annotation.Nullable
    public UUID getTileId() {
        if (this.newChestData == null) {
            return null;
        }
        return this.newChestData.getTileId();
    }

    public CompoundTag writeItems() {
        CompoundTag result = new CompoundTag();
        return ContainerHelper.m_18973_((CompoundTag)result, this.contents);
    }

    public String writeName() {
        return Component.Serializer.m_130703_((Component)this.name);
    }

    @Override
    public NonNullList<ItemStack> getInventoryContents() {
        return this.contents;
    }

    public void resizeInventory(int newSize) {
        if (newSize > this.contents.size()) {
            NonNullList<ItemStack> oldContents = this.contents;
            this.contents = NonNullList.m_122780_((int)newSize, (Object)ItemStack.f_41583_);
            for (int i = 0; i < oldContents.size(); ++i) {
                this.contents.set(i, (Object)((ItemStack)oldContents.get(i)));
            }
            LootrAPI.LOG.info("Resized inventory with key '" + this.newChestData.getKey() + "' in dimension '" + this.newChestData.getDimension() + "' at location '" + this.newChestData.getPos() + "' from " + oldContents.size() + " slots to " + newSize + " slots.");
        } else if (newSize < this.contents.size()) {
            throw new IllegalArgumentException("Cannot resize inventory associated with '" + this.newChestData.getKey() + "' in dimension '" + this.newChestData.getDimension() + "' at location '" + this.newChestData.getPos() + "' to a smaller size.");
        }
    }
}

