/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.drama;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.common.util.drama.DramaConstants;
import me.desht.pneumaticcraft.lib.Log;

public class DramaGenerator {
    private static final Pattern KEYWORD = Pattern.compile("^%\\{(\\w+)}");
    private static final Map<String, Shuffler> shufflers = new HashMap<String, Shuffler>();

    public static String generateDrama() {
        String[] words;
        ThreadLocalRandom r = ThreadLocalRandom.current();
        shufflers.clear();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String word : words = DramaGenerator.pick(r, DramaConstants.SENTENCES).split(" ")) {
            Matcher m = KEYWORD.matcher(word);
            if (m.find()) {
                String grp = m.group(1);
                if (DramaConstants.PARTS.containsKey(grp)) {
                    String[] strings = DramaConstants.PARTS.get(grp);
                    String s = shufflers.computeIfAbsent(grp, k -> new Shuffler(r, strings)).nextEntry();
                    builder.add((Object)s);
                } else {
                    Log.warning("unknown sentence part type: %s", word);
                }
                DramaConstants.PARTS.get(m.group(1));
                continue;
            }
            builder.add((Object)word);
        }
        return String.join((CharSequence)" ", (Iterable<? extends CharSequence>)builder.build());
    }

    private static String pick(Random random, String[] a) {
        return a[random.nextInt(a.length)];
    }

    private static class Shuffler {
        private final Random random;
        private final String[] strings;
        private int nextIdx = 0;

        public Shuffler(Random random, String[] strings) {
            this.random = random;
            this.strings = strings;
            this.shuffleArray(strings);
        }

        public String nextEntry() {
            String res = this.strings[this.nextIdx];
            if (++this.nextIdx >= this.strings.length) {
                this.nextIdx = 0;
            }
            return res;
        }

        private void shuffleArray(String[] array) {
            for (int i = array.length - 1; i > 0; --i) {
                int index = this.random.nextInt(i + 1);
                String temp = array[index];
                array[index] = array[i];
                array[i] = temp;
            }
        }
    }
}

