/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class GlobalPosHelper {
    public static Tag toNBT(GlobalPos globalPos) {
        return (Tag)GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)globalPos).result().orElseThrow();
    }

    public static GlobalPos fromNBT(CompoundTag tag) {
        return (GlobalPos)GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElseThrow();
    }

    public static JsonElement toJson(GlobalPos pos) {
        return (JsonElement)GlobalPos.f_122633_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pos).result().orElseThrow();
    }

    public static GlobalPos fromJson(JsonObject json) {
        return (GlobalPos)GlobalPos.f_122633_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElseThrow();
    }

    public static ServerLevel getWorldForGlobalPos(GlobalPos pos) {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(pos.m_122640_());
    }

    public static GlobalPos makeGlobalPos(Level w, BlockPos pos) {
        return GlobalPos.m_122643_((ResourceKey)w.m_46472_(), (BlockPos)pos);
    }

    public static boolean isSameWorld(GlobalPos pos, Level world) {
        return pos.m_122640_().compareTo(world.m_46472_()) == 0;
    }

    public static String prettyPrint(GlobalPos pos) {
        BlockPos p = pos.m_122646_();
        String dim = pos.m_122640_().m_135782_().toString();
        return String.format("%s [%d,%d,%d]", dim, p.m_123341_(), p.m_123342_(), p.m_123343_());
    }

    public static BlockEntity getTileEntity(GlobalPos globalPos) {
        ServerLevel world = GlobalPosHelper.getWorldForGlobalPos(globalPos);
        if (world != null && world.m_46749_(globalPos.m_122646_())) {
            return world.m_7702_(globalPos.m_122646_());
        }
        return null;
    }
}

