/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.curios;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.MemoryStickItem;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosTickerCapability {
    public static void addCuriosCap(final AttachCapabilitiesEvent<ItemStack> event) {
        event.addCapability(PneumaticRegistry.RL("curio_ticker"), (ICapabilityProvider)new CuriosTickerProvider(new ICurio(){

            public ItemStack getStack() {
                return (ItemStack)event.getObject();
            }

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (MemoryStickItem.shouldAbsorbXPOrbs((ItemStack)event.getObject()) && livingEntity instanceof Player) {
                    MemoryStickItem.cacheMemoryStickLocation((Player)livingEntity, MemoryStickItem.MemoryStickLocator.namedInv(identifier, index));
                }
            }
        }));
    }

    private static class CuriosTickerProvider
    implements ICapabilityProvider {
        final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

        CuriosTickerProvider(ICurio curio) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.capability);
        }
    }
}

