/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.cofhcore;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.ItemVolumeModifier;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class HoldingEnchantableProvider {
    static Enchantment holdingEnchantment = null;
    private static final boolean holdingEnabled = (Double)ConfigHelper.common().integration.cofhHoldingMultiplier.get() > 0.0;

    static void registerVolumeModifier() {
        holdingEnchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("cofh_core", "holding"));
        if (holdingEnchantment != null && holdingEnabled) {
            PneumaticRegistry.getInstance().getItemRegistry().registerPneumaticVolumeModifier(new C0FHVolumeModifier(holdingEnchantment));
        }
    }

    public record C0FHVolumeModifier(Enchantment holding) implements ItemVolumeModifier
    {
        @Override
        public int getNewVolume(ItemStack stack, int oldVolume) {
            return (int)Math.ceil((double)oldVolume * ((double)(1 + EnchantmentHelper.m_44843_((Enchantment)this.holding, (ItemStack)stack)) * (Double)ConfigHelper.common().integration.cofhHoldingMultiplier.get()));
        }

        @Override
        public void addInfo(ItemStack stack, List<Component> text) {
            int nHolding = EnchantmentHelper.m_44843_((Enchantment)this.holding, (ItemStack)stack);
            if (nHolding > 0) {
                text.add((Component)Component.m_237113_((String)"\u25b6 ").m_7220_(this.holding.m_44700_(nHolding)));
            }
        }
    }
}

