/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JetBootsHandler
extends BaseArmorUpgradeHandler<JetBootsLocalState> {
    public static final int BUILDER_MODE_LEVEL = 3;
    public static final int STABILIZERS_LEVEL = 4;

    @Override
    public ResourceLocation getID() {
        return BuiltinArmorUpgrades.JET_BOOTS;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{ModUpgrades.JET_BOOTS.get()};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.FEET;
    }

    @Override
    public Supplier<JetBootsLocalState> extensionData() {
        return JetBootsLocalState::new;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        if (commonArmorHandler.isOnCooldown(EquipmentSlot.FEET)) {
            return;
        }
        int jetbootsCount = commonArmorHandler.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.JET_BOOTS.get());
        if (jetbootsCount == 0) {
            return;
        }
        int jetbootsAirUsage = 0;
        Player player = commonArmorHandler.getPlayer();
        JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        if (commonArmorHandler.hasMinPressure(EquipmentSlot.FEET)) {
            if (jbState.isActive()) {
                if (jbState.isBuilderMode() && jetbootsCount >= 3) {
                    this.setYMotion((Entity)player, player.m_6144_() ? 0.0 : 0.15 + 0.15 * (double)(jetbootsCount - 3));
                    jetbootsAirUsage = (int)((float)((Integer)ConfigHelper.common().armor.jetBootsAirUsage.get() * jetbootsCount) / 2.5f);
                } else {
                    Vec3 lookVec = player.m_20154_().m_82490_(0.3 * (double)jetbootsCount);
                    jbLocal.updateAccel(lookVec);
                    lookVec = jbLocal.getEffectiveMotion(lookVec, player.m_21255_());
                    player.m_20334_(lookVec.f_82479_, player.m_20096_() ? 0.0 : lookVec.f_82480_, lookVec.f_82481_);
                    jetbootsAirUsage = jbLocal.calcAirUsage(jetbootsCount);
                }
                if (player.m_20069_()) {
                    jetbootsAirUsage *= 4;
                }
                jbLocal.tickActive();
            } else if (jbState.isEnabled() && !this.isOnGround(player) && !player.m_21255_()) {
                double xMotion;
                boolean reallyHovering = jbLocal.canHover() && (!jbLocal.isSmartHover() || jbLocal.isHovering());
                boolean stopped = jbLocal.isFlightStabilizers() && jetbootsCount >= 4 && PneumaticCraftUtils.epsilonEquals(player.f_20902_, 0.0f) && PneumaticCraftUtils.epsilonEquals(player.f_20900_, 0.0f);
                double d = xMotion = stopped ? 0.0 : player.m_20184_().f_82479_;
                double yMotion = reallyHovering ? (player.m_6144_() ? -0.45 : -0.1 + 0.02 * (double)jetbootsCount) : player.m_20184_().f_82480_;
                double zMotion = stopped ? 0.0 : player.m_20184_().f_82481_;
                player.m_20256_(new Vec3(xMotion, yMotion, zMotion));
                if (reallyHovering) {
                    player.f_19789_ = 0.0f;
                }
                jetbootsAirUsage = reallyHovering ? (int)((float)((Integer)ConfigHelper.common().armor.jetBootsAirUsage.get()).intValue() * (player.m_6144_() ? 0.25f : 0.5f)) : 0;
                jbLocal.resetAccel();
            } else if (this.isOnGround(player)) {
                jbLocal.setHovering(false);
            } else {
                jbLocal.resetAccel();
            }
        } else {
            if (jbState.isEnabled() && !player.m_20096_() && !player.m_21255_() && jbLocal.isHovering()) {
                jetbootsAirUsage = 1;
            }
            this.setJetBootsActive(commonArmorHandler, false);
        }
        if (jetbootsAirUsage != 0 && !player.m_9236_().f_46443_) {
            if (jbLocal.getPrevJetBootsAirUsage() == 0) {
                NetworkHandler.sendToAllTracking(new PacketPlayMovingSound(MovingSounds.Sound.JET_BOOTS, PacketPlayMovingSound.MovingSoundFocus.of((Entity)player)), player.m_9236_(), player.m_20183_());
                AdvancementTriggers.FLIGHT.trigger((ServerPlayer)player);
            }
            if (player.f_19862_) {
                double vel = player.m_20184_().m_82553_();
                if (player.m_9236_().m_46791_() == Difficulty.HARD) {
                    vel *= 2.0;
                } else if (player.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    vel *= 1.5;
                }
                if (vel > 2.0) {
                    player.m_5496_(vel > 2.5 ? SoundEvents.f_11908_ : SoundEvents.f_11916_, 1.0f, 1.0f);
                    player.m_6469_(player.m_269291_().m_269515_(), (float)vel);
                    AdvancementTriggers.FLY_INTO_WALL.trigger((ServerPlayer)player);
                }
            }
            commonArmorHandler.addAir(EquipmentSlot.FEET, -jetbootsAirUsage);
            if (player.m_20182_().f_82480_ > (double)(player.m_9236_().m_151558_() + 64)) {
                player.m_36335_().m_41524_((Item)ModItems.PNEUMATIC_BOOTS.get(), 20);
            }
        }
        jbLocal.setPrevJetBootsAirUsage(jetbootsAirUsage);
    }

    private boolean isOnGround(Player player) {
        if (player.m_20096_()) {
            return true;
        }
        if (!player.m_9236_().f_46443_) {
            BlockPos pos = player.m_20097_();
            VoxelShape shape = player.m_9236_().m_8055_(pos).m_60812_((BlockGetter)player.m_9236_(), pos);
            if (!shape.m_83281_()) {
                return player.m_20191_().m_82386_(0.0, -0.01, 0.0).m_82381_(shape.m_83215_().m_82338_(pos));
            }
        }
        return false;
    }

    @Override
    public void onInit(ICommonArmorHandler commonArmorHandler) {
        Player player = commonArmorHandler.getPlayer();
        ItemStack armorStack = player.m_6844_(EquipmentSlot.FEET);
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        jbLocal.flightStabilizers = PneumaticArmorItem.getBooleanData(armorStack, "JetBootsStabilizers", false);
        jbLocal.jetBootsPower = (float)PneumaticArmorItem.getIntData(armorStack, "JetBootsPower", 100, 0, 100) / 100.0f;
        jbLocal.hover = PneumaticArmorItem.getBooleanData(armorStack, "Hover", true);
        jbLocal.smartHover = PneumaticArmorItem.getBooleanData(armorStack, "SmartHover", false);
        boolean jetBootsBuilderMode = PneumaticArmorItem.getBooleanData(armorStack, "JetBootsBuilderMode", false);
        JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
        JetBootsStateTracker.getTracker(player).setJetBootsState(player, jbState.isEnabled(), jbState.isActive(), jetBootsBuilderMode);
    }

    @Override
    public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
        Player player = commonArmorHandler.getPlayer();
        JetBootsStateTracker tracker = JetBootsStateTracker.getTracker(player);
        JetBootsStateTracker.JetBootsState jbs = tracker.getJetBootsState(player);
        tracker.setJetBootsState(player, newState, jbs.isActive(), jbs.isBuilderMode());
        super.onToggle(commonArmorHandler, newState);
    }

    @Override
    public void onShutdown(ICommonArmorHandler commonArmorHandler) {
        this.setJetBootsActive(commonArmorHandler, false);
    }

    @Override
    public void onDataFieldUpdated(ICommonArmorHandler commonArmorHandler, String tagName, Tag inbt) {
        Player player = commonArmorHandler.getPlayer();
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        switch (tagName) {
            case "JetBootsBuilderMode": {
                JetBootsStateTracker.getTracker(player).getJetBootsState(player).setBuilderMode(((ByteTag)inbt).m_7063_() == 1);
                break;
            }
            case "JetBootsPower": {
                jbLocal.jetBootsPower = Mth.m_14036_((float)((float)((IntTag)inbt).m_7047_() / 100.0f), (float)0.0f, (float)1.0f);
                break;
            }
            case "JetBootsStabilizers": {
                jbLocal.flightStabilizers = ((ByteTag)inbt).m_7063_() == 1;
                break;
            }
            case "Hover": {
                jbLocal.hover = ((ByteTag)inbt).m_7063_() == 1;
                break;
            }
            case "SmartHover": {
                jbLocal.smartHover = ((ByteTag)inbt).m_7063_() == 1;
            }
        }
    }

    public void setJetBootsActive(ICommonArmorHandler commonArmorHandler, boolean newActive) {
        Player player = commonArmorHandler.getPlayer();
        JetBootsStateTracker.JetBootsState jbs = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        if (!newActive) {
            jbLocal.resetActive();
            if (jbLocal.isFlightStabilizers() && jbs.isActive() && !jbs.isBuilderMode()) {
                if (!player.m_9236_().f_46443_) {
                    double l = Math.pow(player.m_20184_().m_82553_(), 1.65);
                    commonArmorHandler.addAir(EquipmentSlot.FEET, (int)(l * -50.0));
                    NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0, (int)(l * 2.0), 0.0, 0.0, 0.0), player.m_9236_(), player.m_20183_());
                }
                player.m_20256_(Vec3.f_82478_);
            }
        }
        if (jbLocal.isSmartHover()) {
            jbLocal.setHovering(true);
        }
        JetBootsStateTracker.getTracker(player).setJetBootsState(player, jbs.isEnabled(), newActive, jbs.isBuilderMode());
        player.setForcedPose(newActive && !jbs.isBuilderMode() ? Pose.FALL_FLYING : null);
    }

    private void setYMotion(Entity entity, double y) {
        Vec3 v = entity.m_20184_();
        v = v.m_82520_(0.0, y - v.f_82480_, 0.0);
        entity.m_20256_(v);
    }

    public JetBootsStateTracker.JetBootsState getJetBootsSyncedState(ICommonArmorHandler commonArmorHandler) {
        return JetBootsStateTracker.getTracker(commonArmorHandler.getPlayer()).getJetBootsState(commonArmorHandler.getPlayer());
    }

    public static class JetBootsLocalState
    implements IArmorExtensionData {
        public boolean hover;
        public boolean smartHover;
        public boolean flightStabilizers;
        public float jetBootsPower;
        private float flightAccel = 1.0f;
        private int prevJetBootsAirUsage;
        private int jetBootsActiveTicks;
        private boolean hovering;

        public void tickActive() {
            ++this.jetBootsActiveTicks;
        }

        public void resetActive() {
            this.jetBootsActiveTicks = 0;
        }

        public void updateAccel(Vec3 lookVec) {
            float div = lookVec.f_82480_ > 0.0 ? -64.0f : -16.0f;
            this.flightAccel = Mth.m_14036_((float)(this.flightAccel + (float)lookVec.f_82480_ / div), (float)0.8f, (float)4.2f);
        }

        public Vec3 getEffectiveMotion(Vec3 lookVec, boolean gliding) {
            lookVec = lookVec.m_82490_((double)(this.flightAccel * this.jetBootsPower));
            if (!gliding && this.jetBootsActiveTicks < 20 && this.jetBootsActiveTicks > 0) {
                lookVec = lookVec.m_82490_((double)this.jetBootsActiveTicks * 0.05);
            }
            return lookVec;
        }

        public boolean isHovering() {
            return this.hovering;
        }

        public void setHovering(boolean hovering) {
            this.hovering = hovering;
        }

        public int getPrevJetBootsAirUsage() {
            return this.prevJetBootsAirUsage;
        }

        public void setPrevJetBootsAirUsage(int prevJetBootsAirUsage) {
            this.prevJetBootsAirUsage = prevJetBootsAirUsage;
        }

        public void resetAccel() {
            this.flightAccel = 1.0f;
        }

        public int calcAirUsage(int jetbootsCount) {
            return (int)((float)((Integer)ConfigHelper.common().armor.jetBootsAirUsage.get() * jetbootsCount) * this.jetBootsPower);
        }

        public boolean canHover() {
            return this.hover;
        }

        public boolean isSmartHover() {
            return this.smartHover;
        }

        public boolean isFlightStabilizers() {
            return this.flightStabilizers;
        }
    }
}

