/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public abstract class PacketUpdateTubeModule
extends LocationIntPacket {
    private final Direction moduleSide;

    public PacketUpdateTubeModule(AbstractTubeModule module) {
        super(module.getTube().m_58899_());
        this.moduleSide = module.getDirection();
    }

    public PacketUpdateTubeModule(FriendlyByteBuf buffer) {
        super(buffer);
        this.moduleSide = Direction.m_122376_((int)buffer.readByte());
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeByte((int)((byte)this.moduleSide.m_122411_()));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                PneumaticCraftUtils.getTileEntityAt((BlockGetter)player.m_20193_(), this.pos, PressureTubeBlockEntity.class).ifPresent(arg_0 -> this.lambda$handle$0((Player)player, arg_0));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    protected abstract void onModuleUpdate(AbstractTubeModule var1, Player var2);

    private /* synthetic */ void lambda$handle$0(Player player, PressureTubeBlockEntity te) {
        AbstractTubeModule tm = te.getModule(this.moduleSide);
        if (tm != null && PneumaticCraftUtils.canPlayerReach(player, te.m_58899_())) {
            this.onModuleUpdate(tm, player);
        }
    }
}

