/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.SmartChestBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSyncSmartChest
extends LocationIntPacket {
    private final int lastSlot;
    private final List<Pair<Integer, ItemStack>> filter;

    public PacketSyncSmartChest(SmartChestBlockEntity te) {
        super(te.m_58899_());
        this.lastSlot = te.getLastSlot();
        this.filter = te.getFilter();
    }

    PacketSyncSmartChest(FriendlyByteBuf buffer) {
        super(buffer);
        this.lastSlot = buffer.m_130242_();
        int nFilters = buffer.m_130242_();
        this.filter = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < nFilters; ++i) {
            int slot = buffer.m_130242_();
            ItemStack stack = buffer.m_130267_();
            this.filter.add((Pair<Integer, ItemStack>)Pair.of((Object)slot, (Object)stack));
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.m_130130_(this.lastSlot);
        buf.m_130130_(this.filter.size());
        for (Pair<Integer, ItemStack> p : this.filter) {
            buf.m_130130_(((Integer)p.getLeft()).intValue());
            buf.writeItemStack((ItemStack)p.getRight(), true);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketUtil.getBlockEntity((Player)((NetworkEvent.Context)ctx.get()).getSender(), this.pos, SmartChestBlockEntity.class).ifPresent(te -> {
            te.setLastSlot(this.lastSlot);
            te.setFilter(this.filter);
        }));
        ctx.get().setPacketHandled(true);
    }
}

