/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSyncHackSimulationUpdate
extends LocationIntPacket {
    private final List<HackSimulation.ConnectionEntry> playerConns;
    private final List<HackSimulation.ConnectionEntry> aiConns;
    private final List<Pair<Integer, Integer>> fortification;
    private final boolean aiAwake;
    private final boolean aiStopWormed;
    private final boolean aiWon;
    private final boolean playerWon;

    public PacketSyncHackSimulationUpdate(SecurityStationBlockEntity te) {
        super(te.m_58899_());
        HackSimulation aiSim = te.getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
        HackSimulation playerSim = te.getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        this.playerConns = te.getSimulationController().getSimulation((ISimulationController.HackingSide)ISimulationController.HackingSide.PLAYER).allConnections;
        this.aiConns = aiSim.allConnections;
        this.fortification = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < 35; ++i) {
            if (aiSim.getNodeAt(i) == null || aiSim.getNodeAt(i).getFortification() <= 0) continue;
            this.fortification.add((Pair<Integer, Integer>)Pair.of((Object)i, (Object)aiSim.getNodeAt(i).getFortification()));
        }
        this.aiAwake = aiSim.isAwake();
        this.aiStopWormed = aiSim.isStopWormed();
        this.aiWon = aiSim.isHackComplete();
        this.playerWon = playerSim.isHackComplete();
    }

    public PacketSyncHackSimulationUpdate(FriendlyByteBuf buffer) {
        super(buffer);
        this.playerConns = new ArrayList<HackSimulation.ConnectionEntry>();
        int np = buffer.m_130242_();
        for (int i = 0; i < np; ++i) {
            this.playerConns.add(HackSimulation.ConnectionEntry.readFromNetwork(buffer));
        }
        this.aiConns = new ArrayList<HackSimulation.ConnectionEntry>();
        int na = buffer.m_130242_();
        for (int i = 0; i < na; ++i) {
            this.aiConns.add(HackSimulation.ConnectionEntry.readFromNetwork(buffer));
        }
        this.fortification = new ArrayList<Pair<Integer, Integer>>();
        int nf = buffer.m_130242_();
        for (int i = 0; i < nf; ++i) {
            this.fortification.add((Pair<Integer, Integer>)Pair.of((Object)buffer.m_130242_(), (Object)buffer.m_130242_()));
        }
        this.aiAwake = buffer.readBoolean();
        this.aiStopWormed = buffer.readBoolean();
        this.aiWon = buffer.readBoolean();
        this.playerWon = buffer.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.m_130130_(this.playerConns.size());
        this.playerConns.forEach(conn -> conn.write(buffer));
        buffer.m_130130_(this.aiConns.size());
        this.aiConns.forEach(conn -> conn.write(buffer));
        buffer.m_130130_(this.fortification.size());
        this.fortification.forEach(pair -> {
            buffer.m_130130_(((Integer)pair.getLeft()).intValue());
            buffer.m_130130_(((Integer)pair.getRight()).intValue());
        });
        buffer.writeBoolean(this.aiAwake);
        buffer.writeBoolean(this.aiStopWormed);
        buffer.writeBoolean(this.aiWon);
        buffer.writeBoolean(this.playerWon);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ISimulationController controller;
            BlockEntity te = ClientUtils.getBlockEntity(this.pos);
            if (te instanceof SecurityStationBlockEntity && (controller = ((SecurityStationBlockEntity)te).getSimulationController()) != null) {
                HackSimulation aiSim = controller.getSimulation(ISimulationController.HackingSide.AI);
                HackSimulation playerSim = controller.getSimulation(ISimulationController.HackingSide.PLAYER);
                playerSim.syncFromServer(this.playerConns);
                aiSim.syncFromServer(this.aiConns);
                aiSim.updateFortification(this.fortification);
                if (this.aiAwake) {
                    aiSim.wakeUp();
                }
                aiSim.applyStopWorm(this.aiStopWormed ? 100 : 0);
                if (this.aiWon) {
                    aiSim.setHackComplete();
                }
                if (this.playerWon) {
                    playerSim.setHackComplete();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

