/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketSpawnParticle
extends LocationDoublePacket {
    private final ParticleOptions particle;
    private final double dx;
    private final double dy;
    private final double dz;
    private final int numParticles;
    private final double rx;
    private final double ry;
    private final double rz;

    public PacketSpawnParticle(ParticleOptions particle, double x, double y, double z, double dx, double dy, double dz) {
        this(particle, x, y, z, dx, dy, dz, 1, 0.0, 0.0, 0.0);
    }

    public PacketSpawnParticle(ParticleOptions particle, double x, double y, double z, double dx, double dy, double dz, int numParticles, double rx, double ry, double rz) {
        super(x, y, z);
        this.particle = particle;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.numParticles = numParticles;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
    }

    public PacketSpawnParticle(FriendlyByteBuf buffer) {
        super(buffer);
        ParticleType type = (ParticleType)buffer.readRegistryIdSafe(ParticleType.class);
        assert (type != null);
        this.dx = buffer.readDouble();
        this.dy = buffer.readDouble();
        this.dz = buffer.readDouble();
        this.numParticles = buffer.readInt();
        if (this.numParticles > 1) {
            this.rx = buffer.readDouble();
            this.ry = buffer.readDouble();
            this.rz = buffer.readDouble();
        } else {
            this.rz = 0.0;
            this.ry = 0.0;
            this.rx = 0.0;
        }
        this.particle = this.readParticle(type, buffer);
    }

    private <T extends ParticleOptions> T readParticle(ParticleType<T> type, FriendlyByteBuf buffer) {
        return (T)type.m_123743_().m_6507_(type, buffer);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeRegistryId(ForgeRegistries.PARTICLE_TYPES, (Object)this.particle.m_6012_());
        buffer.writeDouble(this.dx);
        buffer.writeDouble(this.dy);
        buffer.writeDouble(this.dz);
        buffer.writeInt(this.numParticles);
        if (this.numParticles > 1) {
            buffer.writeDouble(this.rx);
            buffer.writeDouble(this.ry);
            buffer.writeDouble(this.rz);
        }
        this.particle.m_7711_(new FriendlyByteBuf((ByteBuf)buffer));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world = ClientUtils.getClientLevel();
            for (int i = 0; i < this.numParticles; ++i) {
                double x1 = this.x + (this.numParticles == 1 ? 0.0 : world.f_46441_.m_188500_() * this.rx);
                double y1 = this.y + (this.numParticles == 1 ? 0.0 : world.f_46441_.m_188500_() * this.ry);
                double z1 = this.z + (this.numParticles == 1 ? 0.0 : world.f_46441_.m_188500_() * this.rz);
                world.m_7106_(this.particle, x1, y1, z1, this.dx, this.dy, this.dz);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

