/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketJetBootsStateSync {
    private final UUID playerId;
    private final JetBootsStateTracker.JetBootsState state;

    public PacketJetBootsStateSync(Player player, JetBootsStateTracker.JetBootsState state) {
        this.playerId = player.m_20148_();
        this.state = state;
    }

    PacketJetBootsStateSync(FriendlyByteBuf buf) {
        this.playerId = new UUID(buf.readLong(), buf.readLong());
        this.state = new JetBootsStateTracker.JetBootsState(buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeLong(this.playerId.getMostSignificantBits());
        buf.writeLong(this.playerId.getLeastSignificantBits());
        buf.writeBoolean(this.state.isEnabled());
        buf.writeBoolean(this.state.isActive());
        buf.writeBoolean(this.state.isBuilderMode());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> JetBootsStateTracker.getTracker(ClientUtils.getClientPlayer()).setJetBootsState(this.playerId, this.state));
        ctx.get().setPacketHandled(true);
    }
}

