/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketGuiButton {
    private final String tag;
    private final boolean shiftHeld;

    public PacketGuiButton(String tag) {
        this.tag = tag;
        this.shiftHeld = ClientUtils.hasShiftDown();
    }

    public PacketGuiButton(FriendlyByteBuf buffer) {
        this.tag = buffer.m_130136_(1024);
        this.shiftHeld = buffer.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.tag);
        buffer.writeBoolean(this.shiftHeld);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && player.f_36096_ instanceof IGUIButtonSensitive) {
                ((IGUIButtonSensitive)player.f_36096_).handleGUIButtonPress(this.tag, this.shiftHeld, player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

