/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking;

import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.capabilities.CapabilityHacking;
import me.desht.pneumaticcraft.common.hacking.HackTickTracker;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncEntityHacks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum HackEventListener {
    INSTANCE;


    public static HackEventListener getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void worldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HackTickTracker.getInstance(event.level).tick(event.level);
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(CapabilityHacking.ID, (ICapabilityProvider)new CapabilityHacking.Provider());
    }

    @SubscribeEvent
    public void onEntityJoining(EntityJoinLevelEvent event) {
        event.getEntity().getCapability(PNCCapabilities.HACKING_CAPABILITY).ifPresent(hacking -> hacking.getCurrentHacks().forEach(hack -> HackTickTracker.getInstance(event.getLevel()).trackEntity(event.getEntity(), (IHackableEntity<?>)hack)));
    }

    @SubscribeEvent
    public void onEntityTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            event.getTarget().getCapability(PNCCapabilities.HACKING_CAPABILITY).ifPresent(hacking -> {
                List<ResourceLocation> ids = hacking.getCurrentHacks().stream().map(IHackableEntity::getHackableId).toList();
                if (!ids.isEmpty()) {
                    NetworkHandler.sendToPlayer(new PacketSyncEntityHacks(event.getTarget(), ids), sp);
                }
            });
        }
    }
}

