/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.RecipeCache;
import me.desht.pneumaticcraft.common.recipes.machine.HeatFrameCoolingRecipeImpl;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class HeatFrameEntity
extends AbstractSemiblockEntity {
    private static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.m_135353_(HeatFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> TEMPERATURE = SynchedEntityData.m_135353_(HeatFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MIN_COOKING_TEMP = 373;
    private static final byte IDLE = 0;
    private static final byte COOKING = 1;
    private static final byte COOLING = 2;
    private final IHeatExchangerLogic logic = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap;
    private int lastValidSlot;
    private int cookingProgress;
    private int coolingProgress;
    private final SyncedTemperature syncedTemperature = new SyncedTemperature(this.logic);

    public HeatFrameEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.heatCap = LazyOptional.of(() -> this.logic);
    }

    public IHeatExchangerLogic getHeatExchangerLogic() {
        return this.logic;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATUS, (Object)0);
        this.f_19804_.m_135372_(TEMPERATURE, (Object)0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.HEAT_EXCHANGER_CAPABILITY) {
            return PNCCapabilities.HEAT_EXCHANGER_CAPABILITY.orEmpty(cap, this.heatCap);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canPlace(Direction facing) {
        return this.getCachedTileEntity() != null && this.getCachedTileEntity().getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && !this.getCachedTileEntity().getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent();
    }

    private void setStatus(byte status) {
        this.m_20088_().m_135381_(STATUS, (Object)status);
    }

    private byte getStatus() {
        return (Byte)this.m_20088_().m_135370_(STATUS);
    }

    private void setSyncedTemperature(int temperature) {
        this.m_20088_().m_135381_(TEMPERATURE, (Object)temperature);
    }

    public int getSyncedTemperature() {
        return (Integer)this.m_20088_().m_135370_(TEMPERATURE);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 1) {
            this.logic.initializeAmbientTemperature(this.m_9236_(), this.getBlockPos());
        }
        if (!this.getWorld().f_46443_) {
            byte newStatus = 0;
            if (this.logic.getTemperature() > 373.0) {
                newStatus = this.doCooking();
            } else if (this.logic.getTemperature() < (double)HeatFrameCoolingRecipeImpl.getMaxThresholdTemp(this.getWorld())) {
                newStatus = this.doCooling();
            }
            this.setStatus(newStatus);
            if (newStatus == 0) {
                double delta = this.logic.getTemperature() - this.logic.getAmbientTemperature();
                if (delta > 1.0) {
                    this.logic.addHeat(-0.1);
                } else if (delta < -1.0) {
                    this.logic.addHeat(0.1);
                }
            }
            this.syncedTemperature.tick();
            this.setSyncedTemperature(this.syncedTemperature.getSyncedTemp());
        } else if ((this.f_19797_ & 3) == 0) {
            byte status = this.getStatus();
            switch (status) {
                case 1: {
                    ClientUtils.emitParticles(this.m_9236_(), this.getBlockPos(), (ParticleOptions)(this.m_9236_().f_46441_.m_188503_(4) == 0 ? ParticleTypes.f_123744_ : ParticleTypes.f_123762_));
                    break;
                }
                case 2: {
                    ClientUtils.emitParticles(this.m_9236_(), this.getBlockPos(), (ParticleOptions)ParticleTypes.f_123764_);
                }
            }
        }
    }

    private byte doCooking() {
        byte newStatus = 0;
        if (this.cookingProgress < 100) {
            int progress = Math.max(0, ((int)this.logic.getTemperature() - 343) / 30);
            progress = Math.min(5, progress);
            this.logic.addHeat(-progress);
            this.cookingProgress += progress;
            newStatus = 1;
        }
        if (this.cookingProgress >= 100) {
            IOHelper.getInventoryForTE(this.getCachedTileEntity()).ifPresent(handler -> {
                if (!this.tryCookSlot((IItemHandler)handler, this.lastValidSlot)) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (!this.tryCookSlot((IItemHandler)handler, i)) continue;
                        this.cookingProgress -= 100;
                        break;
                    }
                } else {
                    this.cookingProgress -= 100;
                }
            });
        }
        return newStatus;
    }

    private boolean tryCookSlot(IItemHandler handler, int slot) {
        ItemStack stack;
        if (slot >= 0 & slot < handler.getSlots() && !(stack = handler.getStackInSlot(slot)).m_41619_()) {
            return RecipeCache.SMELTING.getCachedRecipe(this.m_9236_(), (Container)new SimpleContainer(new ItemStack[]{stack})).map(recipe -> {
                ItemStack remainder;
                ItemStack result = recipe.m_8043_(this.m_9236_().m_9598_()).m_41777_();
                if (!result.m_41619_() && (remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)result, (boolean)true)).m_41619_()) {
                    handler.extractItem(slot, 1, false);
                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)result, (boolean)false);
                    this.lastValidSlot = slot;
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private byte doCooling() {
        int newStatus = 0;
        if (this.coolingProgress < 100) {
            int progress = Math.max(0, ((int)this.logic.getTemperature() - 243) / 30);
            progress = 6 - Math.min(5, progress);
            this.logic.addHeat(progress);
            this.coolingProgress += progress;
            newStatus = 2;
        }
        if (this.coolingProgress >= 100) {
            IOHelper.getInventoryForTE(this.getCachedTileEntity()).ifPresent(handler -> {
                if (!this.tryCoolSlot((IItemHandler)handler, this.lastValidSlot)) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (!this.tryCoolSlot((IItemHandler)handler, i)) continue;
                        this.coolingProgress -= 100;
                        break;
                    }
                } else {
                    this.coolingProgress -= 100;
                }
            });
        }
        return (byte)newStatus;
    }

    private boolean tryCoolSlot(IItemHandler handler, int slot) {
        if (slot >= 0 & slot < handler.getSlots()) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.m_41619_()) {
                return false;
            }
            HeatFrameCoolingRecipe recipe = ((PneumaticCraftRecipeType)ModRecipeTypes.HEAT_FRAME_COOLING.get()).findFirst(this.m_9236_(), r -> r.matches(stack));
            if (recipe != null) {
                boolean extractedOK;
                Ingredient ingredient = recipe.getInput();
                if (ingredient instanceof FluidIngredient) {
                    FluidIngredient fluidIngredient = (FluidIngredient)ingredient;
                    if (stack.m_41613_() != 1) {
                        return false;
                    }
                    extractedOK = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> {
                        int toDrain = fluidIngredient.getAmount();
                        if (fluidHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE).getAmount() == toDrain) {
                            ItemStack containerStack = fluidHandler.getContainer().m_41777_();
                            handler.extractItem(slot, 1, false);
                            handler.insertItem(slot, containerStack, false);
                            return true;
                        }
                        return false;
                    }).orElse(false);
                } else {
                    boolean bl = extractedOK = handler.extractItem(slot, 1, false).m_41613_() == 1;
                }
                if (extractedOK) {
                    ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)recipe.getOutput(), (int)recipe.calculateOutputQuantity(this.logic.getTemperature()));
                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)result, (boolean)false);
                    this.lastValidSlot = slot;
                }
                return extractedOK;
            }
        }
        return false;
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.logic.deserializeNBT(tag.m_128469_("heatExchanger"));
        this.cookingProgress = tag.m_128451_("cookingProgress");
        this.coolingProgress = tag.m_128451_("coolingProgress");
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag) {
        tag.m_128365_("heatExchanger", (Tag)this.logic.serializeNBT());
        tag.m_128405_("cookingProgress", this.cookingProgress);
        tag.m_128405_("coolingProgress", this.coolingProgress);
        return super.serializeNBT(tag);
    }

    @Override
    public void addTooltip(Consumer<Component> curInfo, Player player, CompoundTag tag, boolean extended) {
        int cool;
        int cook;
        if (!this.m_9236_().f_46443_) {
            cook = this.cookingProgress;
            cool = this.coolingProgress;
        } else {
            this.logic.deserializeNBT(tag.m_128469_("heatExchanger"));
            cook = tag.m_128451_("cookingProgress");
            cool = tag.m_128451_("coolingProgress");
        }
        if (this.getStatus() != 1 && cook >= 100) {
            cook = 0;
        }
        if (this.getStatus() != 2 && cool >= 100) {
            cool = 0;
        }
        curInfo.accept(HeatUtil.formatHeatString(this.logic.getTemperatureAsInt()));
        if (cook != 0) {
            curInfo.accept((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.heatFrame.cooking", cook).m_130940_(ChatFormatting.GRAY));
        }
        if (cool != 0) {
            curInfo.accept((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.heatFrame.cooling", cool).m_130940_(ChatFormatting.GRAY));
        }
    }
}

