/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class WidgetSerializer {
    public static void writeProgWidgetsToPacket(List<IProgWidget> widgetList, FriendlyByteBuf buf) {
        buf.m_130130_(widgetList.size());
        for (IProgWidget progWidget : widgetList) {
            progWidget.writeToPacket(buf);
        }
    }

    public static List<IProgWidget> readWidgetsFromPacket(FriendlyByteBuf buf) {
        ArrayList<IProgWidget> widgets = new ArrayList<IProgWidget>();
        int nWidgets = buf.m_130242_();
        for (int i = 0; i < nWidgets; ++i) {
            try {
                IProgWidget widget = ProgWidget.fromPacket(buf);
                if (!widget.isAvailable()) {
                    Log.warning("ignoring unavailable widget type " + widget.getTypeID().toString(), new Object[0]);
                    continue;
                }
                widgets.add(widget);
                continue;
            }
            catch (IllegalStateException e) {
                Log.warning(e.getMessage(), new Object[0]);
            }
        }
        return widgets;
    }

    public static List<IProgWidget> getWidgetsFromNBT(CompoundTag tag) {
        ArrayList<IProgWidget> newWidgets = new ArrayList<IProgWidget>();
        ListTag widgetTags = tag.m_128437_("pneumaticcraft:progWidgets", 10);
        for (int i = 0; i < widgetTags.size(); ++i) {
            IProgWidget addedWidget = ProgWidget.fromNBT(widgetTags.m_128728_(i));
            if (addedWidget == null) continue;
            if (addedWidget.isAvailable()) {
                newWidgets.add(addedWidget);
                continue;
            }
            Log.warning("ignoring unavailable widget type: " + String.valueOf(addedWidget.getType()), new Object[0]);
        }
        return newWidgets;
    }

    public static void putWidgetsToNBT(List<IProgWidget> widgets, CompoundTag tag) {
        ListTag widgetTags = new ListTag();
        for (IProgWidget widget : widgets) {
            CompoundTag widgetTag = new CompoundTag();
            widget.writeToNBT(widgetTag);
            widgetTags.add(widgetTags.size(), (Tag)widgetTag);
        }
        tag.m_128365_("pneumaticcraft:progWidgets", (Tag)widgetTags);
    }
}

