/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemAssign;
import me.desht.pneumaticcraft.common.item.TagFilterItem;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class ProgWidgetItemFilter
extends ProgWidget
implements IVariableWidget {
    private ItemStack filter = ItemStack.f_41583_;
    public boolean useItemDurability;
    public boolean useNBT;
    public boolean useModSimilarity;
    public boolean matchBlock;
    private DroneAIManager aiManager;
    private String variable = "";

    public ProgWidgetItemFilter() {
        super((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
    }

    public static ProgWidgetItemFilter withFilter(ItemStack filter) {
        ProgWidgetItemFilter widget = new ProgWidgetItemFilter();
        widget.filter = filter;
        return widget;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.isEmpty() && this.filter == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.error.noFilter", new Object[0]));
        }
        if (this.matchBlock && !(this.filter.m_41720_() instanceof BlockItem) && this.variable.isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.error.notBlock", new Object[0]));
        }
    }

    @Override
    public void addWarnings(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addWarnings(curInfo, widgets);
        int n = 1;
        for (IProgWidget p = this.getParent(); p != null; p = p.getParent()) {
            if (p instanceof ProgWidgetItemAssign && n > 1) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.warning.ignoredItemAssign", new Object[0]));
                break;
            }
            ++n;
        }
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return this.variable.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.varAsTextComponent(this.variable));
    }

    @Nonnull
    public ItemStack getFilter() {
        return this.variable.isEmpty() ? this.filter : (this.aiManager != null ? this.aiManager.getStack(this.aiManager.getDrone().getOwnerUUID(), this.variable) : ItemStack.f_41583_);
    }

    public ItemStack getRawFilter() {
        return this.filter;
    }

    public void setFilter(@Nonnull ItemStack filter) {
        this.filter = filter.m_41777_();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.variable.isEmpty()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.variable", new Object[0]).m_130946_(": ").m_7220_(this.varAsTextComponent(this.variable)).m_130940_(ChatFormatting.AQUA));
        } else if (!this.filter.m_41619_()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.filterLabel", new Object[0]).m_130940_(ChatFormatting.AQUA).m_130946_(": ").m_7220_(this.filter.m_41786_()));
            if (this.filter.m_41720_() == ModItems.TAG_FILTER.get()) {
                curTooltip.addAll(TagFilterItem.getConfiguredTagList(this.filter).stream().map(s -> Symbols.bullet().m_7220_((Component)Component.m_237113_((String)s.f_203868_().toString()).m_130940_(ChatFormatting.YELLOW))).toList());
            }
        }
        if (this.useModSimilarity) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.matchMod", ModNameCache.getModName(this.filter.m_41720_())).m_130940_(ChatFormatting.DARK_AQUA));
        } else if (this.matchBlock) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.matchBlock", new Object[0]).m_130940_(ChatFormatting.DARK_AQUA));
        } else {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter." + (this.useItemDurability ? "useDurability" : "ignoreDurability"), new Object[0]).m_130940_(ChatFormatting.DARK_AQUA));
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter." + (this.useNBT ? "useNBT" : "ignoreNBT"), new Object[0]).m_130940_(ChatFormatting.DARK_AQUA));
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return (ProgWidgetType)ModProgWidgets.ITEM_FILTER.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get()));
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ITEM_FILTER;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (!this.filter.m_41619_()) {
            this.filter.m_41739_(tag);
        }
        if (this.useItemDurability) {
            tag.m_128379_("useMetadata", true);
        }
        if (this.useNBT) {
            tag.m_128379_("useNBT", true);
        }
        if (this.useModSimilarity) {
            tag.m_128379_("useModSimilarity", true);
        }
        if (this.matchBlock) {
            tag.m_128379_("matchBlock", true);
        }
        if (!this.variable.isEmpty()) {
            tag.m_128359_("variable", this.variable);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.filter = ItemStack.m_41712_((CompoundTag)tag);
        this.useItemDurability = this.filter.m_41776_() > 0 && tag.m_128471_("useMetadata");
        this.useNBT = tag.m_128471_("useNBT");
        this.useModSimilarity = tag.m_128471_("useModSimilarity");
        this.matchBlock = tag.m_128471_("matchBlock");
        this.variable = tag.m_128461_("variable");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.m_130055_(this.filter);
        buf.writeBoolean(this.useItemDurability);
        buf.writeBoolean(this.useNBT);
        buf.writeBoolean(this.useModSimilarity);
        buf.writeBoolean(this.matchBlock);
        buf.m_130070_(this.variable);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.filter = buf.m_130267_();
        this.useItemDurability = buf.readBoolean();
        this.useNBT = buf.readBoolean();
        this.useModSimilarity = buf.readBoolean();
        this.matchBlock = buf.readBoolean();
        this.variable = buf.m_130136_(64);
    }

    public static boolean isItemValidForFilters(ItemStack item, List<ProgWidgetItemFilter> whitelist, List<ProgWidgetItemFilter> blacklist, BlockState blockState) {
        if (blacklist != null) {
            for (ProgWidgetItemFilter black : blacklist) {
                if (!ProgWidgetItemFilter.matchFilter(item, blockState, black)) continue;
                return false;
            }
        }
        if (whitelist == null || whitelist.size() == 0) {
            return true;
        }
        for (ProgWidgetItemFilter white : whitelist) {
            if (!ProgWidgetItemFilter.matchFilter(item, blockState, white)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchFilter(ItemStack stack, BlockState blockState, ProgWidgetItemFilter filter) {
        if (filter.matchBlock && blockState != null && filter.getFilter().m_41720_() instanceof BlockItem) {
            return blockState.m_60734_() == ((BlockItem)filter.getFilter().m_41720_()).m_40614_();
        }
        if (PneumaticCraftUtils.doesItemMatchFilter(filter.getFilter(), stack, filter.useItemDurability && blockState == null, filter.useNBT, filter.useModSimilarity)) {
            return blockState == null || !filter.useItemDurability;
        }
        return false;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GRAY;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }
}

