/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import java.util.BitSet;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class AxisOptions {
    public static final AxisOptions TRUE = new AxisOptions(true, true, true);
    private final BitSet options = new BitSet(3);

    public AxisOptions(boolean x, boolean y, boolean z) {
        this.options.set(0, x);
        this.options.set(1, y);
        this.options.set(2, z);
    }

    public boolean shouldCheck(Direction.Axis axis) {
        return this.options.get(axis.ordinal());
    }

    public void setCheck(Direction.Axis axis, boolean check) {
        this.options.set(axis.ordinal(), check);
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128379_("checkX", this.shouldCheck(Direction.Axis.X));
        nbt.m_128379_("checkY", this.shouldCheck(Direction.Axis.Y));
        nbt.m_128379_("checkZ", this.shouldCheck(Direction.Axis.Z));
    }

    public void readFromNBT(CompoundTag nbt, boolean def) {
        this.setCheck(Direction.Axis.X, nbt.m_128441_("checkX") ? nbt.m_128471_("checkX") : def);
        this.setCheck(Direction.Axis.Y, nbt.m_128441_("checkY") ? nbt.m_128471_("checkY") : def);
        this.setCheck(Direction.Axis.Z, nbt.m_128441_("checkZ") ? nbt.m_128471_("checkZ") : def);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.shouldCheck(Direction.Axis.X));
        buffer.writeBoolean(this.shouldCheck(Direction.Axis.Y));
        buffer.writeBoolean(this.shouldCheck(Direction.Axis.Z));
    }

    public void readFromBuffer(FriendlyByteBuf buffer) {
        this.setCheck(Direction.Axis.X, buffer.readBoolean());
        this.setCheck(Direction.Axis.Y, buffer.readBoolean());
        this.setCheck(Direction.Axis.Z, buffer.readBoolean());
    }
}

