/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.EmptySpawnerBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.SpawnerExtractorMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.mixin.accessors.BaseSpawnerAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;

public class SpawnerExtractorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
MenuProvider {
    private static final int MAX_ENTITY_RANGE = 6;
    private Entity cachedEntity;
    @DescSynced
    private Mode mode = Mode.INIT;
    @DescSynced
    private float targetSpeed;
    private float rotationDegrees;
    private float prevRotationDegrees;
    @GuiSynced
    private float progress;
    private float currentSpeed;
    private int spawnFailures;

    public SpawnerExtractorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SPAWNER_EXTRACTOR.get(), pos, state, PressureTier.TIER_ONE, 4000, 4);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        if (Math.abs(this.currentSpeed - this.targetSpeed) < 0.015f) {
            this.currentSpeed = this.targetSpeed;
        } else if (this.currentSpeed < this.targetSpeed) {
            this.currentSpeed += Math.max(0.005f, (this.targetSpeed - this.currentSpeed) / 20.0f);
        } else if (this.currentSpeed > this.targetSpeed) {
            this.currentSpeed -= Math.max(0.01f, (this.targetSpeed - this.currentSpeed) / 10.0f);
        }
        if (this.mode == Mode.INIT) {
            this.updateMode();
        }
        switch (this.mode) {
            case RUNNING: {
                float incr = this.currentSpeed / 1200.0f;
                this.progress = Math.min(1.0f, this.progress + incr);
                break;
            }
            case FINISHED: {
                this.progress = 1.0f;
                this.targetSpeed = 0.0f;
                this.rotationDegrees = this.prevRotationDegrees;
            }
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        this.prevRotationDegrees = this.rotationDegrees;
        this.rotationDegrees += this.currentSpeed * 18.0f;
    }

    @Override
    public void tickServer() {
        int defenderChance;
        super.tickServer();
        int n = defenderChance = this.nonNullLevel().m_46791_() == Difficulty.EASY ? 40 : 20;
        if (this.mode == Mode.RUNNING) {
            this.addAir(1);
            if (this.progress >= 1.0f) {
                this.extractSpawnerCore();
            } else if (this.currentSpeed > 0.1f && this.nonNullLevel().f_46441_.m_188503_(defenderChance) == 0) {
                this.nonNullLevel().m_141902_(this.f_58858_.m_7495_(), BlockEntityType.f_58925_).ifPresent(te -> {
                    if (!this.trySpawnDefender((SpawnerBlockEntity)te)) {
                        ++this.spawnFailures;
                    }
                });
            }
        }
        if ((this.nonNullLevel().m_46467_() & 0xFL) == 3L) {
            this.targetSpeed = this.getTargetSpeed();
        }
        if ((this.nonNullLevel().m_46467_() & 0x3FL) == 3L) {
            this.spawnFailures = Math.max(0, this.spawnFailures - 1);
        }
    }

    private boolean trySpawnDefender(SpawnerBlockEntity te) {
        double z;
        BaseSpawner spawner = te.m_59801_();
        int spawnRange = 4;
        int maxNearbyEntities = 16;
        CompoundTag nbt = ((BaseSpawnerAccess)spawner).getNextSpawnData().m_186567_();
        Optional optional = EntityType.m_20637_((CompoundTag)nbt);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos pos = te.m_58899_();
        ListTag listnbt = nbt.m_128437_("Pos", 6);
        int size = listnbt.size();
        Level level = this.nonNullLevel();
        double x = size >= 1 ? listnbt.m_128772_(0) : (double)pos.m_123341_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * (double)spawnRange + 0.5;
        double y = size >= 2 ? listnbt.m_128772_(1) : (double)(pos.m_123342_() + level.f_46441_.m_188503_(3) - 1);
        double d = z = size >= 3 ? listnbt.m_128772_(2) : (double)pos.m_123343_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * (double)spawnRange + 0.5;
        if (level.m_45772_(((EntityType)optional.get()).m_20585_(x, y, z))) {
            ServerLevel serverworld = (ServerLevel)level;
            Entity entity = EntityType.m_20645_((CompoundTag)nbt, (Level)level, e1 -> {
                e1.m_7678_(x, y, z, e1.m_146908_(), e1.m_146909_());
                return e1;
            });
            if (entity == null) {
                return false;
            }
            int entityCount = level.m_45976_(entity.getClass(), new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_82400_((double)spawnRange)).size();
            if (entityCount >= maxNearbyEntities) {
                return false;
            }
            entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), level.f_46441_.m_188501_() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                Mob mobentity = (Mob)entity;
                if (nbt.m_128440_() == 1 && nbt.m_128425_("id", 8)) {
                    ForgeEventFactory.onFinalizeSpawn((Mob)mobentity, (ServerLevelAccessor)serverworld, (DifficultyInstance)serverworld.m_6436_(this.getPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
                    if (level.m_46791_() == Difficulty.HARD) {
                        this.getRandomEffects(level.f_46441_).forEach(effect -> mobentity.m_7292_(new MobEffectInstance(effect, Integer.MAX_VALUE, 2)));
                    }
                }
            }
            if (!serverworld.m_8860_(entity)) {
                return false;
            }
            level.m_46796_(2004, pos, 0);
            if (entity instanceof Mob) {
                ((Mob)entity).m_21373_();
            }
        }
        return true;
    }

    private List<MobEffect> getRandomEffects(RandomSource rand) {
        ArrayList<MobEffect> l = new ArrayList<MobEffect>();
        int n = rand.m_188503_(100);
        if (n > 50) {
            l.add(MobEffects.f_19607_);
        }
        if (n > 75) {
            l.add(MobEffects.f_19596_);
        }
        if (n > 82) {
            l.add(MobEffects.f_19600_);
        }
        if (n > 92) {
            l.add(MobEffects.f_19605_);
        }
        if (n > 96) {
            l.add(MobEffects.f_19609_);
        }
        return l;
    }

    private void extractSpawnerCore() {
        this.nonNullLevel().m_141902_(this.f_58858_.m_7495_(), BlockEntityType.f_58925_).ifPresent(te -> {
            ItemStack spawnerCore = new ItemStack((ItemLike)ModItems.SPAWNER_CORE.get());
            ISpawnerCoreStats stats = PneumaticRegistry.getInstance().getItemRegistry().getSpawnerCoreStats(spawnerCore);
            Entity e = this.getCachedEntity((SpawnerBlockEntity)te);
            if (e != null && stats != null) {
                stats.addAmount(e.m_6095_(), 100);
                stats.serialize(spawnerCore);
                Level level = this.nonNullLevel();
                ItemEntity item = new ItemEntity(level, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, spawnerCore);
                level.m_7967_((Entity)item);
                level.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 0.5f);
                level.m_7731_(this.f_58858_.m_7495_(), ((EmptySpawnerBlock)ModBlocks.EMPTY_SPAWNER.get()).m_49966_(), 3);
                level.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)Blocks.f_50085_.m_49966_()));
            }
        });
    }

    private float getTargetSpeed() {
        if (this.getPressure() > this.getMinWorkingPressure()) {
            return 0.0f;
        }
        return this.nonNullLevel().m_141902_(this.f_58858_.m_7495_(), BlockEntityType.f_58925_).map(spawner -> {
            int players = 0;
            int matches = 0;
            Entity e0 = this.getCachedEntity((SpawnerBlockEntity)spawner);
            if (e0 == null) {
                return Float.valueOf(0.0f);
            }
            List l = this.nonNullLevel().m_6443_(LivingEntity.class, new AABB(this.f_58858_).m_82400_(6.0), e -> true);
            for (LivingEntity e2 : l) {
                if (e2 instanceof Player && !(e2 instanceof FakePlayer)) {
                    ++players;
                }
                if (e2.m_6095_() != e0.m_6095_()) continue;
                ++matches;
            }
            int n = players > 0 ? Math.min(10, matches + this.spawnFailures) : 10;
            return Float.valueOf(1.0f - (float)n / 10.0f);
        }).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Entity getCachedEntity(SpawnerBlockEntity spawner) {
        if (this.cachedEntity == null) {
            this.cachedEntity = EntityType.m_20645_((CompoundTag)((BaseSpawnerAccess)spawner.m_59801_()).getNextSpawnData().m_186567_(), (Level)this.nonNullLevel(), Function.identity());
        }
        return this.cachedEntity;
    }

    public float getRotationDegrees() {
        return this.rotationDegrees;
    }

    public float getPrevRotationDegrees() {
        return this.prevRotationDegrees;
    }

    public float getProgress() {
        return this.progress;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("progress", this.progress);
        tag.m_128344_("mode", (byte)this.mode.ordinal());
        tag.m_128350_("targetSpeed", this.targetSpeed);
        tag.m_128405_("spawnFailures", this.spawnFailures);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128457_("progress");
        this.mode = Mode.values()[tag.m_128445_("mode")];
        this.targetSpeed = tag.m_128457_("targetSpeed");
        this.spawnFailures = tag.m_128451_("spawnFailures");
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.m_122434_().m_122479_();
    }

    @Override
    public float getMinWorkingPressure() {
        return this.mode == Mode.RUNNING ? -0.5f : 0.0f;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new SpawnerExtractorMenu(windowId, inv, this.f_58858_);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 2), (double)(this.f_58858_.m_123343_() + 1));
    }

    public void updateMode() {
        BlockState below = this.nonNullLevel().m_8055_(this.f_58858_.m_7495_());
        this.mode = below.m_60734_() instanceof SpawnerBlock ? Mode.RUNNING : Mode.FINISHED;
    }

    public static enum Mode {
        INIT,
        RUNNING,
        FINISHED;

    }
}

