/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHasBoundingBlocks;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.SolarCompressorMenu;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.BoundingBlockEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IHeatExchangingTE,
MenuProvider,
IHasBoundingBlocks {
    public static final double MAX_TEMPERATURE = 698.15;
    public static final double WARNING_TEMPERATURE = 683.15;
    private static final Vec3i[] SURROUNDING_BLOCK_OFFSETS = new Vec3i[]{new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(1, 0, 1), new Vec3i(-1, 0, -1)};
    @GuiSynced
    private float airPerTick;
    private float airBuffer;
    @GuiSynced
    private boolean isBroken = false;
    @GuiSynced
    private boolean canSeeSunlight = false;
    @GuiSynced
    private IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    private final BoundingBlockEntityData boundingBlockEntityData = new BoundingBlockEntityData();

    public SolarCompressorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SOLAR_COMPRESSOR.get(), pos, state, PressureTier.TIER_TWO, 10000, 4);
        if (this.isBounding(this)) {
            this.heatExchanger.setThermalCapacity(0.0);
            this.heatExchanger.setThermalResistance(1.0E9);
        } else {
            this.heatExchanger.setThermalCapacity(100.0);
        }
    }

    @Override
    @NotNull
    public BoundingBlockEntityData getBoundingBlockEntityData() {
        return this.boundingBlockEntityData;
    }

    public boolean isBroken() {
        return this.isBroken;
    }

    public void fixBroken() {
        this.isBroken = false;
    }

    public void breakCompressor() {
        if (!this.isBounding(this)) {
            this.isBroken = true;
            this.heatExchanger.setTemperature(this.heatExchanger.getAmbientTemperature());
            Level level = this.nonNullLevel();
            BlockPos mainPos = this.m_58899_();
            for (Vec3i offset : SURROUNDING_BLOCK_OFFSETS) {
                BlockPos offsetPos = mainPos.m_121955_(offset);
                if (level.m_8055_(offsetPos).m_60734_() != Blocks.f_50016_) continue;
                level.m_46597_(offsetPos, Blocks.f_50083_.m_49966_());
            }
            if (!level.m_5776_()) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)mainPos.m_123341_() + 0.5, (double)mainPos.m_123342_() + 0.75, (double)mainPos.m_123343_() + 0.5, 30, 0.0, 0.0, 0.0, 0.15);
            }
            level.m_5594_(null, mainPos, SoundEvents.f_11909_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5594_(null, mainPos, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public float getHeatEfficiency() {
        double temperature = this.heatExchanger.getTemperatureAsInt();
        return (float)Mth.m_14008_((double)Math.pow(temperature / 312.15, 3.0), (double)0.0, (double)8.0);
    }

    public int getPercentHeatEfficiency() {
        return (int)Mth.m_14036_((float)(this.getHeatEfficiency() / 8.0f * 100.0f), (float)1.0f, (float)100.0f);
    }

    public int getTemperature() {
        return this.heatExchanger.getTemperatureAsInt();
    }

    public boolean canGenerateAir() {
        return this.getCanSeeSunlight() && !this.isBroken;
    }

    public void canSeeSunlight() {
        Level level = this.nonNullLevel();
        this.canSeeSunlight = this.isBounding(this) || level.m_46462_() || level.m_46471_() ? false : level.m_45527_(this.m_58899_().m_7918_(0, 1, 0)) && level.m_45527_(this.m_58899_().m_7918_(0, 1, 1)) && level.m_45527_(this.m_58899_().m_7918_(0, 1, -1));
    }

    public boolean getCanSeeSunlight() {
        return this.canSeeSunlight;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (!this.isBounding(this)) {
            Level level = this.nonNullLevel();
            if (level.m_46467_() % 5L == 0L) {
                float baseModifier = 2.0f * this.getSpeedUsageMultiplierFromUpgrades();
                float heatModifier = this.getHeatEfficiency();
                float configModifier = ((Double)ConfigHelper.common().machines.solarCompressorMultiplier.get()).floatValue();
                this.airPerTick = baseModifier * heatModifier * configModifier;
            }
            this.canSeeSunlight();
            if (this.canGenerateAir()) {
                this.heatExchanger.setThermalResistance(1.0);
                this.airBuffer += this.airPerTick;
                if (this.airBuffer >= 1.0f) {
                    int toAdd = (int)this.airBuffer;
                    this.addAir(toAdd);
                    this.airBuffer -= (float)toAdd;
                    double heatToAdd = Math.round((double)toAdd / 20.0) + 2L;
                    this.heatExchanger.addHeat(heatToAdd);
                }
            } else {
                this.heatExchanger.setThermalResistance(1.0E9);
            }
            if (this.heatExchanger.getTemperature() < 698.15 && this.heatExchanger.getTemperature() > 683.15 && level.m_46467_() % 20L == 0L) {
                BlockPos mainPos = this.m_58899_();
                if (!level.m_5776_()) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)mainPos.m_123341_() + 0.5, (double)mainPos.m_123342_() + 1.2, (double)mainPos.m_123343_() + 0.5, 10, 0.0, 0.0, 0.0, 0.05);
                }
            }
            if (!this.isBroken && this.heatExchanger.getTemperature() > 698.15) {
                this.breakCompressor();
            }
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return !this.isBounding(this) && (side == this.getRotation() || side == this.getRotation().m_122424_());
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        if (this.isBounding(this)) {
            return LazyOptional.empty();
        }
        return this.heatCap;
    }

    public float getAirRate() {
        if (this.isBroken) {
            return 0.0f;
        }
        return this.airPerTick;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        if (this.isBounding(this)) {
            return null;
        }
        return new SolarCompressorMenu(i, playerInventory, this.m_58899_());
    }

    @Override
    @Nullable
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        if (this.isBounding(this)) {
            return null;
        }
        return this.heatExchanger;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isBroken = tag.m_128471_("IsBroken");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.isBroken) {
            tag.m_128379_("IsBroken", true);
        }
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        super.serializeExtraItemData(blockEntityTag, preserveState);
        if (this.isBroken) {
            blockEntityTag.m_128379_("IsBroken", true);
        }
    }
}

