/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class RangeManager {
    private final BlockEntity te;
    private final int renderColour;
    private int range = 0;
    private boolean showRange = false;
    private AABB extents;
    private Supplier<AABB> extentsGenerator;
    private Set<BlockPos> frame;

    public RangeManager(BlockEntity te, int renderColour) {
        this.te = te;
        this.renderColour = renderColour;
        this.extentsGenerator = () -> new AABB(te.m_58899_(), te.m_58899_()).m_82400_((double)this.range);
        this.setRange(1);
    }

    public RangeManager withCustomExtents(Supplier<AABB> generator) {
        this.extentsGenerator = generator;
        return this;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int newRange) {
        if (newRange != this.range) {
            this.range = newRange;
            this.extents = this.extentsGenerator.get();
            Set<Object> set = this.frame = this.te.m_58904_() != null && this.te.m_58904_().m_5776_() ? RangeManager.getFrame(this.extents) : Collections.emptySet();
            if (this.shouldShowRange() && this.te.m_58904_() != null && this.te.m_58904_().m_5776_()) {
                this.toggleShowRange();
                this.toggleShowRange();
            }
        }
    }

    public void toggleShowRange() {
        boolean bl = this.showRange = !this.showRange;
        if (this.te.m_58904_() != null && this.te.m_58904_().m_5776_()) {
            if (this.showRange) {
                AreaRenderManager.getInstance().showArea(this.frame, this.renderColour, this.te, false);
            } else {
                AreaRenderManager.getInstance().removeHandlers(this.te);
            }
        }
    }

    public boolean shouldShowRange() {
        return this.showRange;
    }

    public AABB getExtents() {
        return this.extents;
    }

    public static Set<BlockPos> getFrame(AABB extents) {
        HashSet<BlockPos> res = new HashSet<BlockPos>();
        int minX = (int)extents.f_82288_;
        int minY = (int)extents.f_82289_;
        int minZ = (int)extents.f_82290_;
        int maxX = (int)extents.f_82291_;
        int maxY = (int)extents.f_82292_;
        int maxZ = (int)extents.f_82293_;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                    res.add(new BlockPos(x, y, z));
                }
            }
        }
        return res;
    }
}

