/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import me.desht.pneumaticcraft.common.block.entity.AbstractAssemblyRobotBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public class AssemblyDrillBlockEntity
extends AbstractAssemblyRobotBlockEntity {
    @DescSynced
    private boolean isDrillOn;
    @DescSynced
    @LazySynced
    private float drillSpeed;
    public float drillRotation;
    public float oldDrillRotation;
    private int drillStep;

    public AssemblyDrillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.ASSEMBLY_DRILL.get()), pos, state);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.oldDrillRotation = this.drillRotation;
        this.drillSpeed = this.isDrillOn ? Math.min(this.drillSpeed + 1.0f * this.speed, 100.0f) : Math.max(this.drillSpeed - 1.0f * this.speed, 0.0f);
        this.drillRotation += this.drillSpeed;
        while (this.drillRotation >= 360.0f) {
            this.drillRotation -= 360.0f;
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.drillStep > 0) {
            AbstractAssemblyRobotBlockEntity.TargetDirections platformDirection = this.getPlatformDirection();
            if (platformDirection == null) {
                this.drillStep = 1;
            }
            switch (this.drillStep) {
                case 1: 
                case 6: {
                    this.slowMode = false;
                    this.gotoHomePosition();
                    break;
                }
                case 2: {
                    this.hoverOverNeighbour(platformDirection);
                    break;
                }
                case 3: {
                    this.isDrillOn = true;
                    break;
                }
                case 4: {
                    this.slowMode = true;
                    this.gotoNeighbour(platformDirection);
                    break;
                }
                case 5: {
                    AssemblyPlatformBlockEntity platform;
                    ItemStack output;
                    this.hoverOverNeighbour(platformDirection);
                    this.isDrillOn = false;
                    BlockEntity te = this.getTileEntityForCurrentDirection();
                    if (!(te instanceof AssemblyPlatformBlockEntity) || (output = this.getDrilledOutputForItem((platform = (AssemblyPlatformBlockEntity)te).getHeldStack())).m_41619_()) break;
                    platform.setHeldStack(output);
                }
            }
            if (this.isDoneInternal()) {
                ++this.drillStep;
                if (this.drillStep > 6) {
                    this.drillStep = 0;
                }
            }
        }
    }

    public void goDrilling() {
        if (this.drillStep == 0) {
            this.drillStep = 1;
            this.m_6596_();
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("drill", this.isDrillOn);
        tag.m_128350_("drillSpeed", this.drillSpeed);
        tag.m_128405_("drillStep", this.drillStep);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isDrillOn = tag.m_128471_("drill");
        this.drillSpeed = tag.m_128457_("drillSpeed");
        this.drillStep = tag.m_128451_("drillStep");
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean isIdle() {
        return this.drillStep == 0 && this.isDoneInternal();
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.DRILL;
    }

    private boolean isDoneInternal() {
        if (super.isDoneMoving()) {
            return this.isDrillOn ? this.drillSpeed > 99.0f : PneumaticCraftUtils.epsilonEquals(this.drillSpeed, 0.0f);
        }
        return false;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return false;
    }

    private ItemStack getDrilledOutputForItem(ItemStack input) {
        return ((PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_DRILL.get()).stream(this.f_58857_).filter(recipe -> recipe.matches(input)).findFirst().map(recipe -> recipe.getOutput().m_41777_()).orElse(ItemStack.f_41583_);
    }

    @Override
    public boolean reset() {
        if (this.isIdle()) {
            return true;
        }
        this.isDrillOn = false;
        this.drillStep = 6;
        return false;
    }
}

