/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.render.fluid.IFluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.RenderLiquidHopper;
import me.desht.pneumaticcraft.common.block.OmnidirectionalHopperBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.LiquidHopperBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.FluidItemWrapper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.IFluidRendered;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class LiquidHopperBlock
extends OmnidirectionalHopperBlock
implements PneumaticCraftEntityBlock {
    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new LiquidHopperBlockEntity(pPos, pState);
    }

    public static class ItemBlockLiquidHopper
    extends BlockItem
    implements ColorHandlers.ITintableItem,
    IFluidRendered {
        public static final String TANK_NAME = "Tank";
        RenderLiquidHopper.ItemRenderInfoProvider renderInfoProvider = null;

        public ItemBlockLiquidHopper(Block block) {
            super(block, ModItems.defaultProps());
        }

        public boolean hasCraftingRemainingItem(ItemStack stack) {
            return true;
        }

        public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
            boolean creative = UpgradableItemUtils.hasCreativeUpgrade(itemStack);
            return (ItemStack)FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
                handler.drain(1000, creative ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                return handler.getContainer().m_41777_();
            }).orElseThrow(RuntimeException::new);
        }

        @javax.annotation.Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @javax.annotation.Nullable CompoundTag nbt) {
            return new FluidItemWrapper(stack, TANK_NAME, 16000);
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            int n = UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.CREATIVE.get());
            return n > 0 ? -2406705 : -13949145;
        }

        @Override
        public IFluidItemRenderInfoProvider getFluidItemRenderer() {
            if (this.renderInfoProvider == null) {
                this.renderInfoProvider = new RenderLiquidHopper.ItemRenderInfoProvider();
            }
            return this.renderInfoProvider;
        }
    }
}

