/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderResponse;
import me.desht.pneumaticcraft.common.util.CountedItemStacks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class ShoppingBasket
implements Iterable<ResourceLocation> {
    private final Map<ResourceLocation, Integer> basket = new Object2IntLinkedOpenHashMap();

    public static ShoppingBasket fromNBT(CompoundTag subTag) {
        ShoppingBasket res = new ShoppingBasket();
        if (subTag != null) {
            for (String key : subTag.m_128431_()) {
                int count = subTag.m_128451_(key);
                if (count <= 0) continue;
                res.setUnits(new ResourceLocation(key), count);
            }
        }
        return res;
    }

    public CompoundTag toNBT() {
        CompoundTag subTag = new CompoundTag();
        this.basket.forEach((? super K key, ? super V value) -> {
            if (value > 0) {
                subTag.m_128405_(key.toString(), value.intValue());
            }
        });
        return subTag;
    }

    public int getUnits(ResourceLocation offerId) {
        return this.basket.getOrDefault(offerId, 0);
    }

    public void setUnits(ResourceLocation offerId, int units) {
        this.basket.put(offerId, units);
    }

    public void addUnitsToOffer(ResourceLocation offerId, int toAdd) {
        this.basket.put(offerId, Math.max(0, this.getUnits(offerId) + toAdd));
        this.removeIfEmpty(offerId);
    }

    public void remove(ResourceLocation offerId) {
        this.basket.remove(offerId);
    }

    public void halve(ResourceLocation offerId) {
        this.basket.put(offerId, this.getUnits(offerId) / 2);
        this.removeIfEmpty(offerId);
    }

    private void removeIfEmpty(ResourceLocation offerId) {
        if (this.getUnits(offerId) == 0) {
            this.basket.remove(offerId);
        }
    }

    public void clear() {
        this.basket.clear();
    }

    @Override
    public Iterator<ResourceLocation> iterator() {
        return this.basket.keySet().iterator();
    }

    public AmadronMenu.EnumProblemState validate(ItemStack tablet, boolean allOffers) {
        if (this.basket.isEmpty()) {
            return AmadronMenu.EnumProblemState.NO_PROBLEMS;
        }
        LazyOptional<IItemHandler> itemCap = AmadronTabletItem.getItemCapability(tablet);
        LazyOptional<IFluidHandler> fluidCap = AmadronTabletItem.getFluidCapability(tablet);
        if (this.basket.keySet().removeIf(offerId -> {
            AmadronRecipe offer = AmadronOfferManager.getInstance().getOffer((ResourceLocation)offerId);
            boolean inputOk = offer.getInput().apply(itemStack -> itemCap.isPresent(), fluidStack -> fluidCap.isPresent());
            boolean outputOk = offer.getOutput().apply(itemStack -> itemCap.isPresent(), fluidStack -> fluidCap.isPresent());
            return !inputOk || !outputOk;
        })) {
            return AmadronMenu.EnumProblemState.NO_INVENTORY;
        }
        CountedItemStacks itemAmounts = itemCap.map(CountedItemStacks::new).orElse(new CountedItemStacks());
        Map<Fluid, Integer> fluidAmounts = ShoppingBasket.countFluids(fluidCap);
        AmadronMenu.EnumProblemState problem = AmadronMenu.EnumProblemState.NO_PROBLEMS;
        for (ResourceLocation offerId2 : this.basket.keySet()) {
            int units;
            AmadronRecipe offer = AmadronOfferManager.getInstance().getOffer(offerId2);
            int units0 = this.getUnits(offerId2);
            if (offer.getMaxStock() >= 0 && units0 > offer.getStock()) {
                units = offer.getStock();
                this.setUnits(offerId2, units);
                problem = offer.getStock() == 0 ? AmadronMenu.EnumProblemState.OUT_OF_STOCK : AmadronMenu.EnumProblemState.NOT_ENOUGH_STOCK;
            } else {
                units = units0;
            }
            problem = problem.addProblem(offer.getInput().apply(itemStack -> {
                int available = itemAmounts.getOrDefault(itemStack, 0);
                int needed = itemStack.m_41613_() * units;
                if (allOffers) {
                    itemAmounts.put(itemStack, available - needed);
                }
                if (available < needed) {
                    this.setUnits(offerId2, available / itemStack.m_41613_());
                    return AmadronMenu.EnumProblemState.NOT_ENOUGH_ITEMS;
                }
                return AmadronMenu.EnumProblemState.NO_PROBLEMS;
            }, fluidStack -> {
                int available = fluidAmounts.getOrDefault(fluidStack.getFluid(), 0);
                int needed = fluidStack.getAmount() * units;
                if (allOffers) {
                    fluidAmounts.put(fluidStack.getFluid(), available / fluidStack.getAmount());
                }
                if (available < needed) {
                    this.setUnits(offerId2, available / fluidStack.getAmount());
                    return AmadronMenu.EnumProblemState.NOT_ENOUGH_FLUID;
                }
                return AmadronMenu.EnumProblemState.NO_PROBLEMS;
            }));
            problem = this.verifyDroneSpace(problem, offerId2, offer.getInput());
            if (problem == AmadronMenu.EnumProblemState.NO_PROBLEMS) {
                problem = this.verifyDroneSpace(problem, offerId2, offer.getOutput());
            }
            problem = problem.addProblem(offer.getOutput().apply(itemStack -> {
                int availableSpace = offer.getOutput().findSpaceInItemOutput(itemCap, units);
                if (availableSpace < units) {
                    this.setUnits(offerId2, availableSpace);
                    return AmadronMenu.EnumProblemState.NOT_ENOUGH_ITEM_SPACE;
                }
                return AmadronMenu.EnumProblemState.NO_PROBLEMS;
            }, fluidStack -> {
                int availableTrades = Math.min(576000 / fluidStack.getAmount(), offer.getOutput().findSpaceInFluidOutput(fluidCap, units));
                if (availableTrades < units) {
                    this.setUnits(offerId2, availableTrades);
                    return AmadronMenu.EnumProblemState.NOT_ENOUGH_FLUID_SPACE;
                }
                return AmadronMenu.EnumProblemState.NO_PROBLEMS;
            }));
        }
        this.basket.keySet().removeIf(offerId -> this.basket.get(offerId) == 0);
        return problem;
    }

    private AmadronMenu.EnumProblemState verifyDroneSpace(AmadronMenu.EnumProblemState curProb, ResourceLocation offerId, AmadronTradeResource resource) {
        return curProb.addProblem(resource.apply(itemStack -> {
            int stacks = resource.totalSpaceRequired(this.getUnits(offerId));
            if (stacks > 36) {
                int maxItems = 36 * itemStack.m_41741_();
                this.setUnits(offerId, maxItems / itemStack.m_41613_());
                return AmadronMenu.EnumProblemState.TOO_MANY_ITEMS;
            }
            return AmadronMenu.EnumProblemState.NO_PROBLEMS;
        }, fluidStack -> {
            int space = resource.totalSpaceRequired(this.getUnits(offerId));
            if (space > 576000) {
                this.setUnits(offerId, 576000 / fluidStack.getAmount());
                return AmadronMenu.EnumProblemState.TOO_MUCH_FLUID;
            }
            return AmadronMenu.EnumProblemState.NO_PROBLEMS;
        }));
    }

    public void syncToPlayer(ServerPlayer player) {
        this.basket.forEach((? super K offerId, ? super V units) -> NetworkHandler.sendToPlayer(new PacketAmadronOrderResponse((ResourceLocation)offerId, (int)units), player));
    }

    public boolean isEmpty() {
        return this.basket.values().stream().noneMatch(amount -> amount > 0);
    }

    private static Map<Fluid, Integer> countFluids(LazyOptional<IFluidHandler> fluidCap) {
        return fluidCap.map(handler -> {
            HashMap<Fluid, Integer> result = new HashMap<Fluid, Integer>();
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack stack = handler.getFluidInTank(i);
                result.merge(stack.getFluid(), stack.getAmount(), Integer::sum);
            }
            return result;
        }).orElse(Collections.emptyMap());
    }
}

