/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.semiblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.model.entity.semiblocks.ModelLogisticsFrame;
import me.desht.pneumaticcraft.client.render.entity.semiblock.RenderSemiblockBase;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RenderLogisticsFrame
extends RenderSemiblockBase<AbstractLogisticsFrameEntity> {
    private final ModelLogisticsFrame model;

    public RenderLogisticsFrame(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new ModelLogisticsFrame(ctx.m_174023_(PNCModelLayers.LOGISTICS_FRAME));
    }

    public void render(AbstractLogisticsFrameEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction side;
        float alpha = (float)entity.getAlpha() / 255.0f;
        if (alpha == 0.0f) {
            return;
        }
        if (entity.isAir()) {
            return;
        }
        matrixStackIn.m_85836_();
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks, matrixStackIn);
        }
        matrixStackIn.m_85837_(0.0, (side = entity.getSide()).m_122434_() == Direction.Axis.Y ? 0.5 : -0.5, 0.0);
        switch (side) {
            case UP: {
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                matrixStackIn.m_252880_(0.0f, -1.0f, 0.0f);
                break;
            }
            case DOWN: {
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                matrixStackIn.m_252880_(0.0f, -1.0f, 0.0f);
                break;
            }
            case NORTH: {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                break;
            }
            case WEST: {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
        }
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        this.model.m_7695_(matrixStackIn, builder, this.kludgeLightingLevel(entity, packedLightIn), OverlayTexture.m_118090_((float)0.0f, (boolean)false), 1.0f, 1.0f, 1.0f, alpha);
        matrixStackIn.m_85849_();
    }

    public Vec3 getRenderOffset(AbstractLogisticsFrameEntity entityIn, float partialTicks) {
        VoxelShape shape = entityIn.getBlockState().m_60808_((BlockGetter)entityIn.getWorld(), entityIn.getBlockPos());
        double yOff = (shape.m_83297_(Direction.Axis.Y) - shape.m_83288_(Direction.Axis.Y)) / 2.0;
        return switch (entityIn.getSide()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vec3(0.0, shape.m_83288_(Direction.Axis.Y), 0.0);
            case Direction.UP -> new Vec3(0.0, shape.m_83297_(Direction.Axis.Y) - 1.0, 0.0);
            case Direction.NORTH -> new Vec3(0.0, yOff - 0.5, shape.m_83288_(Direction.Axis.Z));
            case Direction.SOUTH -> new Vec3(0.0, yOff - 0.5, shape.m_83297_(Direction.Axis.Z) - 1.0);
            case Direction.WEST -> new Vec3(shape.m_83288_(Direction.Axis.X), yOff - 0.5, 0.0);
            case Direction.EAST -> new Vec3(shape.m_83297_(Direction.Axis.X) - 1.0, yOff - 0.5, 0.0);
        };
    }

    public ResourceLocation getTextureLocation(AbstractLogisticsFrameEntity entityLogisticsFrame) {
        return entityLogisticsFrame.getTexture();
    }
}

