/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCrafting;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class ProgWidgetRenderer {
    private static final Map<ProgWidgetType<?>, BiConsumer<GuiGraphics, IProgWidget>> ITEM_RENDERERS = new HashMap();
    private static final Map<ProgWidgetType<?>, BiConsumer<GuiGraphics, IProgWidget>> EXTRA_RENDERERS = new HashMap();

    public static void renderProgWidget2d(GuiGraphics graphics, IProgWidget progWidget, int alpha) {
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)progWidget.getTexture());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        Matrix4f posMat = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder wr = Tesselator.m_85913_().m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        wr.m_252986_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, (float)height, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, v).m_5752_();
        wr.m_252986_(posMat, (float)width, (float)height, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u, v).m_5752_();
        wr.m_252986_(posMat, (float)width, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u, 0.0f).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public static void renderProgWidget2d(GuiGraphics graphics, IProgWidget progWidget) {
        ProgWidgetRenderer.renderProgWidget2d(graphics, progWidget, 255);
    }

    public static void renderProgWidget3d(PoseStack matrixStack, MultiBufferSource buffer, IProgWidget progWidget) {
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(progWidget.getTexture()), (posMat, builder) -> {
            builder.m_252986_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(posMat, (float)width, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, 0.0f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(posMat, (float)width, (float)height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(posMat, 0.0f, (float)height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, v).m_85969_(0xF000F0).m_5752_();
        });
    }

    public static void doExtraRendering2d(GuiGraphics graphics, IProgWidget widget) {
        EXTRA_RENDERERS.getOrDefault(widget.getType(), ProgWidgetRenderer::renderGenericExtras).accept(graphics, widget);
    }

    public static void doItemRendering2d(GuiGraphics graphics, IProgWidget widget) {
        ITEM_RENDERERS.getOrDefault(widget.getType(), (p, w) -> {}).accept(graphics, widget);
    }

    public static <P extends IProgWidget> void registerExtraRenderer(ProgWidgetType<P> type, BiConsumer<GuiGraphics, P> consumer) {
        EXTRA_RENDERERS.put(type, consumer);
    }

    public static <P extends IProgWidget> void registerItemRenderer(ProgWidgetType<P> type, BiConsumer<GuiGraphics, P> consumer) {
        ITEM_RENDERERS.put(type, consumer);
    }

    public static void renderGenericExtras(GuiGraphics graphics, IProgWidget progWidget) {
        List<Component> info = progWidget.getExtraStringInfo();
        if (!info.isEmpty()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            Font fr = Minecraft.m_91087_().f_91062_;
            List<FormattedCharSequence> splittedInfo = GuiUtils.wrapTextComponentList(info, 150, fr);
            for (int i = 0; i < splittedInfo.size(); ++i) {
                int stringWidth = fr.m_92724_(splittedInfo.get(i));
                int startX = progWidget.getWidth() / 2 - stringWidth / 4;
                int n = progWidget.getHeight() / 2;
                Objects.requireNonNull(fr);
                int n2 = n - (9 + 1) * (splittedInfo.size() - 1) / 4;
                Objects.requireNonNull(fr);
                int n3 = n2 + (9 + 1) * i / 2;
                Objects.requireNonNull(fr);
                int startY = n3 - 9 / 4;
                Objects.requireNonNull(fr);
                graphics.m_280509_(startX * 2 - 1, startY * 2 - 1, startX * 2 + stringWidth + 1, startY * 2 + 9 + 1, -1056964609);
                Objects.requireNonNull(fr);
                graphics.m_280637_(startX * 2 - 1, startY * 2 - 1, stringWidth + 2, 9 + 2, -4144960);
                graphics.m_280649_(fr, splittedInfo.get(i), startX * 2, startY * 2, -16777216, false);
            }
            graphics.m_280168_().m_85849_();
        }
    }

    public static void renderCraftingItem(GuiGraphics graphics, ProgWidgetCrafting progWidget) {
        ItemStack recipe = progWidget.getRecipeResult(ClientUtils.getClientLevel());
        if (recipe != null) {
            graphics.m_280480_(recipe, 8, progWidget.getHeight() / 2 - 8);
            graphics.m_280302_(Minecraft.m_91087_().f_91062_, recipe, 8, progWidget.getHeight() / 2 - 8, Integer.toString(recipe.m_41613_()));
        }
    }

    public static void renderItemFilterItem(GuiGraphics graphics, ProgWidgetItemFilter progWidget) {
        if (progWidget.getVariable().isEmpty() && !progWidget.getFilter().m_41619_()) {
            graphics.m_280480_(progWidget.getFilter(), 10, 2);
            graphics.m_280302_(Minecraft.m_91087_().f_91062_, progWidget.getFilter(), 10, 2, "");
        }
    }
}

