/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.PNCWidget;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class WidgetRadioButton
extends PNCWidget<WidgetRadioButton> {
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;
    private boolean checked;
    public final int color;
    private final Consumer<WidgetRadioButton> pressable;
    private final Font fontRenderer;
    private List<Component> tooltip;
    private List<? extends WidgetRadioButton> otherChoices;
    private static final float N_POINTS = 12.0f;

    public WidgetRadioButton(int x, int y, int color, Component text, Consumer<WidgetRadioButton> pressable) {
        super(x, y, 10, 10, text);
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        this.tooltip = new ArrayList<Component>();
        this.otherChoices = null;
        this.f_93618_ = 10 + this.fontRenderer.m_92852_((FormattedText)this.m_6035_());
        this.f_93619_ = 10;
        this.color = color;
        this.pressable = pressable;
    }

    public WidgetRadioButton(int x, int y, int color, Component text) {
        this(x, y, color, text, null);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        this.drawCircle(graphics, (float)x + 5.0f, (float)y + 5.0f, 5.0f, this.f_93623_ ? -6250336 : -6710887);
        this.drawCircle(graphics, (float)x + 5.0f, (float)y + 5.0f, 4.0f, this.f_93623_ ? -14671840 : -5592406);
        if (this.checked) {
            this.drawCircle(graphics, (float)x + 5.0f, (float)y + 5.0f, 1.0f, this.f_93623_ ? -16728064 : -5592406);
        }
        Component component = this.m_6035_();
        Objects.requireNonNull(this.fontRenderer);
        graphics.m_280614_(this.fontRenderer, component, x + 1 + 10, y + 5 - 9 / 2, this.f_93623_ ? this.color : -7829368, false);
    }

    public boolean isChecked() {
        return this.checked;
    }

    void setChecked(boolean checked) {
        this.checked = checked;
    }

    private void drawCircle(GuiGraphics graphics, float x, float y, float radius, int color) {
        BufferBuilder wr = Tesselator.m_85913_().m_85915_();
        int[] cols = RenderUtils.decomposeColor(color);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        wr.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        Matrix4f posMat = graphics.m_280168_().m_85850_().m_252922_();
        int i = 0;
        while ((float)i < 12.0f) {
            float sin = Mth.m_14031_((float)((float)i / 12.0f * (float)Math.PI * 2.0f));
            float cos = Mth.m_14089_((float)((float)i / 12.0f * (float)Math.PI * 2.0f));
            wr.m_252986_(posMat, x + sin * radius, y + cos * radius, 0.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
            ++i;
        }
        Tesselator.m_85913_().m_85914_();
        RenderSystem.disableBlend();
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (this.f_93623_ && !this.checked) {
            for (WidgetRadioButton widgetRadioButton : this.otherChoices) {
                widgetRadioButton.checked = false;
            }
            this.checked = true;
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
        }
    }

    void setOtherChoices(List<? extends WidgetRadioButton> choices) {
        if (this.otherChoices != null) {
            throw new IllegalStateException("otherChoices has already been init'ed!");
        }
        this.otherChoices = choices;
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    public static class Builder<T extends WidgetRadioButton> {
        private final List<T> buttons = new ArrayList<T>();

        private Builder() {
        }

        public static <T extends WidgetRadioButton> Builder<T> create() {
            return new Builder<T>();
        }

        public Builder<T> addRadioButton(T rb, boolean initiallyChecked) {
            ((WidgetRadioButton)((Object)rb)).setChecked(initiallyChecked);
            this.buttons.add(rb);
            return this;
        }

        public List<T> build() {
            return this.build(c -> {});
        }

        public List<T> build(Consumer<T> c) {
            ImmutableList res = ImmutableList.copyOf(this.buttons);
            int checked = 0;
            for (WidgetRadioButton rb : res) {
                if (rb.isChecked()) {
                    ++checked;
                }
                rb.setOtherChoices((List<? extends WidgetRadioButton>)res);
                c.accept(rb);
            }
            if (checked != 1) {
                throw new IllegalStateException("one and only one radio button should be checked!");
            }
            return res;
        }
    }
}

