/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.CoreComponentsClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class WidgetKeybindCheckBox
extends WidgetCheckBox {
    private static final Map<ResourceLocation, WidgetKeybindCheckBox> id2checkBox = new HashMap<ResourceLocation, WidgetKeybindCheckBox>();
    private static WidgetKeybindCheckBox coreComponents;
    private final ResourceLocation upgradeID;
    private ResourceLocation ownerUpgradeID = null;
    private boolean isListeningForBinding;
    private Component oldCheckboxText = this.m_6035_();

    private WidgetKeybindCheckBox(ResourceLocation upgradeID, int x, int y, int color, Consumer<ICheckboxWidget> pressable) {
        super(x, y, color, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.enableModule", PneumaticCraftUtils.xlate(IArmorUpgradeHandler.getStringKey(upgradeID), new Object[0])), pressable);
        this.upgradeID = upgradeID;
    }

    public static WidgetKeybindCheckBox getOrCreate(ResourceLocation upgradeID, int x, int y, int color, Consumer<ICheckboxWidget> pressable) {
        return id2checkBox.computeIfAbsent(upgradeID, id -> {
            WidgetKeybindCheckBox newCheckBox = new WidgetKeybindCheckBox((ResourceLocation)id, x, y, color, pressable);
            newCheckBox.checked = ArmorFeatureStatus.INSTANCE.isUpgradeEnabled((ResourceLocation)id);
            KeyMapping keyMapping = ClientArmorRegistry.getInstance().getKeybindingForUpgrade((ResourceLocation)id);
            if (keyMapping != null && !keyMapping.m_90862_()) {
                KeyDispatcher.in2checkbox.put(InputRecord.forKeyMapping(keyMapping), newCheckBox);
            }
            if (id.equals((Object)CommonUpgradeHandlers.coreComponentsHandler.getID())) {
                coreComponents = newCheckBox;
            }
            return newCheckBox;
        });
    }

    public static WidgetKeybindCheckBox get(ResourceLocation upgradeID) {
        return id2checkBox.get(upgradeID);
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeHandler<?> handler) {
        return WidgetKeybindCheckBox.get(handler.getID());
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeClientHandler<?> handler) {
        return WidgetKeybindCheckBox.get(handler.getID());
    }

    public static WidgetKeybindCheckBox getCoreComponents() {
        return coreComponents;
    }

    @Override
    public ICheckboxWidget withOwnerUpgradeID(ResourceLocation ownerUpgradeID) {
        this.ownerUpgradeID = ownerUpgradeID;
        return this;
    }

    public static boolean isHandlerEnabled(IArmorUpgradeHandler<?> handler) {
        return WidgetKeybindCheckBox.forUpgrade(handler).checked;
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.m_93680_(x, y)) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            if (this.handleClick(x, y, button)) {
                return true;
            }
            if (this.isListeningForBinding) {
                InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(button);
                this.updateBinding(input);
                return true;
            }
        }
        return false;
    }

    public boolean handleClick() {
        return this.handleClick(0.0, 0.0, 0);
    }

    private boolean handleClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            byte idx;
            EquipmentSlot slot;
            if (!WidgetKeybindCheckBox.coreComponents.checked && this != coreComponents) {
                return true;
            }
            CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
            IArmorUpgradeHandler<?> entry = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.upgradeID);
            IArmorUpgradeHandler<?> ownerEntry = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.ownerUpgradeID);
            if (!this.checked && (entry != null ? this != coreComponents && !commonArmorHandler.isArmorReady(entry.getEquipmentSlot()) : ownerEntry != null && !commonArmorHandler.isArmorReady(ownerEntry.getEquipmentSlot()))) {
                return true;
            }
            super.m_5716_(mouseX, mouseY);
            ArmorFeatureStatus.INSTANCE.setUpgradeEnabled(this.upgradeID, this.checked);
            ArmorFeatureStatus.INSTANCE.saveIfChanged();
            if (entry != null && commonArmorHandler.isUpgradeInserted(slot = entry.getEquipmentSlot(), idx = (byte)entry.getIndex())) {
                this.toggleUpgrade(commonArmorHandler, slot, idx);
            }
            if (this == coreComponents) {
                this.toggleAllUpgrades(commonArmorHandler);
            }
            return true;
        }
        if (button == 1) {
            if (Screen.m_96638_()) {
                this.updateBinding(InputConstants.f_84822_);
            } else {
                boolean bl = this.isListeningForBinding = !this.isListeningForBinding;
                if (this.isListeningForBinding) {
                    this.oldCheckboxText = this.m_6035_();
                    this.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.setKeybind", new Object[0]).m_130940_(ChatFormatting.YELLOW));
                } else {
                    this.m_93666_(this.oldCheckboxText);
                }
            }
            return true;
        }
        return false;
    }

    private void toggleUpgrade(CommonArmorHandler commonArmorHandler, EquipmentSlot slot, byte idx) {
        NetworkHandler.sendToServer(new PacketToggleArmorFeature(slot, idx, WidgetKeybindCheckBox.coreComponents.checked && this.checked));
        commonArmorHandler.setUpgradeEnabled(slot, idx, WidgetKeybindCheckBox.coreComponents.checked && this.checked);
        HUDHandler.getInstance().addFeatureToggleMessage(IArmorUpgradeHandler.getStringKey(this.upgradeID), this.checked);
    }

    private void toggleAllUpgrades(CommonArmorHandler commonArmorHandler) {
        ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting> features = new ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting>();
        ArmorUpgradeRegistry.getInstance().entries().forEach(entry -> {
            boolean state = WidgetKeybindCheckBox.coreComponents.checked && WidgetKeybindCheckBox.forUpgrade(entry).checked;
            byte idx = (byte)entry.getIndex();
            features.add(new PacketToggleArmorFeatureBulk.FeatureSetting(entry.getEquipmentSlot(), idx, state));
            commonArmorHandler.setUpgradeEnabled(entry.getEquipmentSlot(), idx, state);
        });
        NetworkHandler.sendToServer(new PacketToggleArmorFeatureBulk(features));
        if (this.checked) {
            ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.coreComponentsHandler, CoreComponentsClientHandler.class).onResolutionChanged();
        } else {
            Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 0.5f);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.isListeningForBinding) {
            InputConstants.Key input = InputConstants.Type.KEYSYM.m_84895_(keyCode);
            if (!KeyModifier.isKeyCodeModifier((InputConstants.Key)input)) {
                this.updateBinding(input);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(graphics, mouseX, mouseY, partialTick);
        this.buildTooltip();
    }

    private void buildTooltip() {
        KeyMapping keyBinding = ClientArmorRegistry.getInstance().getKeybindingForUpgrade(this.upgradeID);
        String k = IArmorUpgradeHandler.getStringKey(this.upgradeID) + ".desc";
        if (keyBinding == null && !I18n.m_118936_((String)k)) {
            this.m_257544_(null);
            return;
        }
        ArrayList<Component> l = new ArrayList<Component>();
        if (I18n.m_118936_((String)k)) {
            l.addAll(GuiUtils.xlateAndSplit(k, new Object[0]));
        }
        if (keyBinding != null) {
            l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindBoundKey", ClientUtils.translateKeyBind(keyBinding)).m_130940_(ChatFormatting.GOLD));
            if (!this.isListeningForBinding) {
                l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindRightClickToSet", new Object[0]).m_130940_(ChatFormatting.GRAY));
                if (keyBinding.getKey().m_84873_() != -1) {
                    l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindShiftRightClickToClear", new Object[0]).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        this.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.combineComponents(l)));
    }

    private void updateBinding(InputConstants.Key input) {
        this.isListeningForBinding = false;
        KeyMapping keyBinding = ClientArmorRegistry.getInstance().getKeybindingForUpgrade(this.upgradeID);
        if (keyBinding != null) {
            KeyModifier mod = input == InputConstants.f_84822_ ? KeyModifier.NONE : KeyModifier.getActiveModifier();
            keyBinding.setKeyModifierAndCode(mod, input);
            Minecraft.m_91087_().f_91066_.m_92159_(keyBinding, input);
            KeyMapping.m_90854_();
            KeyDispatcher.updateBinding(keyBinding, this);
            Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12211_.get(), 1.0f, input == InputConstants.f_84822_ ? 0.5f : 1.0f);
        }
        this.m_93666_(this.oldCheckboxText);
    }

    @Override
    public ResourceLocation getUpgradeId() {
        return this.upgradeID;
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT})
    public static class KeyDispatcher {
        private static final Map<InputRecord, WidgetKeybindCheckBox> in2checkbox = new HashMap<InputRecord, WidgetKeybindCheckBox>();

        @SubscribeEvent
        public static void onKeyPress(InputEvent.Key event) {
            if (Minecraft.m_91087_().f_91080_ == null && event.getAction() == 1) {
                KeyDispatcher.handleInput(InputConstants.Type.KEYSYM.m_84895_(event.getKey()));
            }
        }

        @SubscribeEvent
        public static void onMouseClick(InputEvent.MouseButton event) {
            if (Minecraft.m_91087_().f_91080_ == null && event.getAction() == 1) {
                KeyDispatcher.handleInput(InputConstants.Type.MOUSE.m_84895_(event.getButton()));
            }
        }

        private static void handleInput(InputConstants.Key key) {
            Optional.ofNullable(in2checkbox.get(InputRecord.forKey(key))).ifPresent(WidgetKeybindCheckBox::handleClick);
        }

        private static void updateBinding(KeyMapping mapping, WidgetKeybindCheckBox widget) {
            in2checkbox.values().remove(widget);
            in2checkbox.put(InputRecord.forKeyMapping(mapping), widget);
        }
    }

    private record InputRecord(int key, KeyModifier modifier, InputConstants.Type type) {
        private static InputRecord forKeyMapping(KeyMapping keyMapping) {
            return new InputRecord(keyMapping.getKey().m_84873_(), keyMapping.getKeyModifier(), keyMapping.getKey().m_84868_());
        }

        private static InputRecord forKey(InputConstants.Key key) {
            return new InputRecord(key.m_84873_(), KeyModifier.getActiveModifier(), key.m_84868_());
        }
    }
}

