/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import me.desht.pneumaticcraft.mixin.accessors.TooltipAccess;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class WidgetAmadronOffer
extends AbstractWidget {
    private final AmadronRecipe offer;
    private final List<AbstractWidget> subWidgets = new ArrayList<AbstractWidget>();
    private int shoppingAmount;
    private boolean canBuy;
    private final Rect2i[] tooltipRectangles = new Rect2i[2];
    private boolean renderBackground = true;

    public WidgetAmadronOffer(int x, int y, AmadronRecipe offer) {
        super(x, y, 73, 35, (Component)Component.m_237119_());
        this.offer = offer;
        offer.getInput().accept(itemStack -> this.subWidgets.add((AbstractWidget)new WidgetItemStack(x + 6, y + 13, (ItemStack)itemStack)), fluidStack -> this.subWidgets.add(new WidgetFluidStack(x + 6, y + 15, fluidStack.copy(), null)));
        offer.getOutput().accept(itemStack -> this.subWidgets.add((AbstractWidget)new WidgetItemStack(x + 51, y + 13, (ItemStack)itemStack)), fluidStack -> this.subWidgets.add(new WidgetFluidStack(x + 51, y + 15, fluidStack.copy(), null)));
        if (offer.isRemovableBy((Player)Minecraft.m_91087_().f_91074_)) {
            ArrayList<Component> l = new ArrayList<Component>(GuiUtils.xlateAndSplit("pneumaticcraft.gui.amadron.amadronWidget.sneakRightClickToRemove", new Object[0]));
            l.add((Component)Component.m_237119_());
            WidgetButtonExtended btn = new WidgetButtonExtended(x + 57, y + 1, 11, 11, (Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.RED) + "x")), b -> NetworkHandler.sendToServer(new PacketGuiButton("remove:" + String.valueOf(offer.m_6423_()))));
            btn.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.combineComponents(l)));
            this.subWidgets.add((AbstractWidget)btn);
        }
        this.tooltipRectangles[0] = new Rect2i(x + 5, y + 14, 18, 18);
        this.tooltipRectangles[1] = new Rect2i(x + 50, y + 14, 18, 18);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.subWidgets.forEach(w -> w.m_88315_(graphics, mouseX, mouseY, partialTicks));
        ArrayList<Component> tooltip = new ArrayList<Component>();
        for (AbstractWidget widget : this.subWidgets) {
            Component message;
            if (!widget.m_198029_() || (message = ((TooltipAccess)widget.m_278622_()).getMessage()) == null) continue;
            tooltip.add(message);
        }
        if (Arrays.stream(this.tooltipRectangles).noneMatch(rect -> rect.m_110087_(mouseX, mouseY))) {
            tooltip.addAll(WidgetAmadronOffer.makeTooltip(this.offer, this.shoppingAmount));
        }
        this.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.combineComponents(tooltip)));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.subWidgets.stream().anyMatch(w -> w.m_6375_(mouseX, mouseY, button));
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            Object str;
            Font fr = Minecraft.m_91087_().f_91062_;
            if (this.renderBackground) {
                graphics.m_280163_(Textures.WIDGET_AMADRON_OFFER, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, 256, 256);
            }
            FormattedCharSequence r = (FormattedCharSequence)fr.m_92923_((FormattedText)this.offer.getVendorName(), 73).get(0);
            graphics.m_280649_(fr, r, this.m_252754_() + 2, this.m_252907_() + 2, -16777216, false);
            if (this.shoppingAmount > 0) {
                str = Integer.toString(this.shoppingAmount);
                graphics.drawString(fr, (String)str, (float)(this.m_252754_() + 36) - (float)fr.m_92895_((String)str) / 2.0f, (float)(this.m_252907_() + (this.offer.getStock() >= 0 ? 15 : 20)), -16777216, false);
            }
            if (this.offer.getStock() >= 0) {
                str = ChatFormatting.DARK_BLUE.toString() + this.offer.getStock();
                graphics.drawString(fr, (String)str, (float)(this.m_252754_() + 36) - (float)fr.m_92895_((String)str) / 2.0f, (float)(this.m_252907_() + 25), -16777216, false);
            }
            boolean availableHere = this.offer.isUsableByPlayer(ClientUtils.getClientPlayer());
            if (this.offer.isLocationLimited()) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                graphics.m_280218_(availableHere ? Textures.GUI_OK_LOCATION : Textures.GUI_BAD_LOCATION, this.m_252754_() + this.f_93618_ - 15, this.m_252907_() - 1, 0, 0, 16, 16);
                RenderSystem.disableBlend();
            }
            if (!this.canBuy || !availableHere) {
                graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -1065336768);
            }
        }
    }

    public WidgetAmadronOffer setDrawBackground(boolean drawBackground) {
        this.renderBackground = drawBackground;
        return this;
    }

    public WidgetAmadronOffer setAffordable(boolean canBuy) {
        this.canBuy = canBuy;
        return this;
    }

    public AmadronRecipe getOffer() {
        return this.offer;
    }

    public void setShoppingAmount(int amount) {
        this.shoppingAmount = amount;
    }

    public static List<Component> makeTooltip(AmadronRecipe offer, int shoppingAmount) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.vendor", offer.getVendorName().m_6881_().m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.selling", Component.m_237113_((String)offer.getOutput().toString()).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.buying", Component.m_237113_((String)offer.getInput().toString()).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.YELLOW));
        if (shoppingAmount >= 0) {
            if (offer.getStock() >= 0) {
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.stock", Component.m_237113_((String)Integer.toString(offer.getStock())).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.AQUA));
            }
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.inBasket", Component.m_237113_((String)Integer.toString(shoppingAmount)).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.AQUA));
        }
        if (!offer.isUsableByPlayer(ClientUtils.getClientPlayer())) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.unavailable", new Object[0]).m_130940_(ChatFormatting.RED));
        }
        offer.addAvailabilityData(ClientUtils.getClientPlayer(), tooltip);
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            tooltip.add((Component)Component.m_237113_((String)offer.m_6423_().toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    private static class WidgetItemStack
    extends WidgetButtonExtended {
        public WidgetItemStack(int startX, int startY, ItemStack stack) {
            super(startX, startY, 16, 16);
            this.setRenderStacks(stack);
            this.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.combineComponents(stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_))));
            this.setVisible(false);
            this.setRenderStackSize(true);
        }

        protected boolean m_7972_(int pButton) {
            return false;
        }
    }
}

