/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.AbstractProgWidgetScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ProgWidgetLiquidFilterScreen
extends AbstractProgWidgetScreen<ProgWidgetLiquidFilter> {
    private static final int GRID_WIDTH = 8;
    private static final int GRID_HEIGHT = 6;
    private WidgetFluidFilter mainFilter;
    private WidgetVerticalScrollbar scrollbar;
    private WidgetTextField searchField;
    private int lastScroll;
    private final List<WidgetFluidFilter> visibleFluidWidgets = new ArrayList<WidgetFluidFilter>();
    private int textTimer = 0;

    public ProgWidgetLiquidFilterScreen(ProgWidgetLiquidFilter widget, ProgrammerScreen guiProgrammer) {
        super(widget, guiProgrammer);
        this.xSize = 176;
        this.ySize = 166;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_ITEM_SEARCHER;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.mainFilter = new WidgetFluidFilter(this.guiLeft + 148, this.guiTop + 12, ((ProgWidgetLiquidFilter)this.progWidget).getFluid(), b -> {
            b.setFluid(Fluids.f_76191_);
            ((ProgWidgetLiquidFilter)this.progWidget).setFluid(Fluids.f_76191_);
        });
        this.m_142416_((GuiEventListener)this.mainFilter);
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 8; ++x) {
                WidgetFluidFilter f = new WidgetFluidFilter(this.guiLeft + 8 + x * 18, this.guiTop + 52 + y * 18, Fluids.f_76191_, b -> {
                    this.mainFilter.setFluid(b.getFluid());
                    ((ProgWidgetLiquidFilter)this.progWidget).setFluid(b.getFluid());
                });
                this.m_142416_((GuiEventListener)f);
                this.visibleFluidWidgets.add(f);
            }
        }
        this.searchField = new WidgetTextField(this.f_96547_, this.guiLeft + 8, this.guiTop + 35, 90, 10);
        this.m_142416_((GuiEventListener)this.searchField);
        this.m_7522_((GuiEventListener)this.searchField);
        this.searchField.m_94151_(s -> {
            this.textTimer = 5;
        });
        this.scrollbar = new WidgetVerticalScrollbar(this.guiLeft + 155, this.guiTop + 47, 112);
        this.scrollbar.setListening(true);
        this.m_142416_((GuiEventListener)this.scrollbar);
        this.addValidFluids();
    }

    private void addValidFluids() {
        List<Fluid> fluids = ForgeRegistries.FLUIDS.getValues().stream().filter(fluid -> this.matchSearch(this.searchField.m_94155_(), (Fluid)fluid)).sorted(Comparator.comparing(f -> new FluidStack(f, 1).getDisplayName().getString())).toList();
        this.scrollbar.setStates(Math.max(0, (fluids.size() - 48 + 8 - 1) / 8));
        int offset = this.scrollbar.getState() * 8;
        for (int i = 0; i < this.visibleFluidWidgets.size(); ++i) {
            if (i + offset < fluids.size()) {
                this.visibleFluidWidgets.get(i).setFluid(fluids.get(i + offset));
                continue;
            }
            this.visibleFluidWidgets.get(i).setFluid(Fluids.f_76191_);
        }
    }

    private boolean matchSearch(String srch, Fluid fluid) {
        if (fluid == Fluids.f_76191_ || !fluid.m_7444_(fluid.m_76145_())) {
            return false;
        }
        String srchL = srch.toLowerCase();
        return srch.isEmpty() || new FluidStack(fluid, 1).getDisplayName().getString().toLowerCase().contains(srchL);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.lastScroll != this.scrollbar.getState()) {
            this.lastScroll = this.scrollbar.getState();
            this.addValidFluids();
        } else if (this.textTimer > 0 && --this.textTimer == 0) {
            this.addValidFluids();
        }
    }
}

