/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.options;

import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.client.gui.widget.PNCForgeSlider;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractSliderOptions<T extends IArmorUpgradeClientHandler<?>>
extends IOptionPage.SimpleOptionPage<T> {
    private Integer pendingVal = null;

    AbstractSliderOptions(IGuiScreen screen, T handler) {
        super(screen, handler);
    }

    protected PointXY getSliderPos() {
        return new PointXY(30, 60);
    }

    protected Pair<Integer, Integer> getRange() {
        return Pair.of((Object)0, (Object)100);
    }

    protected abstract String getTagName();

    protected abstract Component getPrefix();

    protected abstract Component getSuffix();

    EquipmentSlot getSlot() {
        return this.getClientUpgradeHandler().getCommonHandler().getEquipmentSlot();
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        Pair<Integer, Integer> range = this.getRange();
        int initVal = (Integer)range.getRight();
        if (Minecraft.m_91087_().f_91074_ != null) {
            ItemStack stack = Minecraft.m_91087_().f_91074_.m_6844_(this.getSlot());
            initVal = PneumaticArmorItem.getIntData(stack, this.getTagName(), (Integer)range.getRight());
        }
        PointXY pos = this.getSliderPos();
        gui.addWidget(new PNCForgeSlider(pos.x(), pos.y(), 150, 20, this.getPrefix(), this.getSuffix(), ((Integer)range.getLeft()).intValue(), ((Integer)range.getRight()).intValue(), initVal, true, slider -> {
            this.pendingVal = slider.getValueInt();
        }));
    }

    @Override
    public void tick() {
        if (this.pendingVal != null && !this.getGuiScreen().getScreen().m_7282_()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_(this.getTagName(), this.pendingVal.intValue());
            Object upgradeHandler = this.getClientUpgradeHandler().getCommonHandler();
            NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(this.getSlot(), tag, upgradeHandler.getID()));
            upgradeHandler.onDataFieldUpdated(CommonArmorHandler.getHandlerForPlayer(), this.getTagName(), tag.m_128423_(this.getTagName()));
            this.pendingVal = null;
        }
    }
}

