/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetList;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.TagWorkbenchBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.TagWorkbenchMenu;
import me.desht.pneumaticcraft.common.item.TagFilterItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class TagWorkbenchScreen
extends AbstractPneumaticCraftContainerScreen<TagWorkbenchMenu, TagWorkbenchBlockEntity> {
    private static final int AVAILABLE_X = 9;
    private static final int SELECTED_X = 123;
    private static final int LIST_HEIGHT = 126;
    private static final int LIST_WIDTH = 98;
    private static final int LIST_Y = 41;
    private Item lastItem = null;
    private ItemStack lastPaperStack = ItemStack.f_41583_;
    private WidgetButtonExtended addButton;
    private WidgetButtonExtended removeButton;
    private WidgetList<ResourceLocation> availableList;
    private WidgetList<ResourceLocation> selectedList;
    private WidgetButtonExtended writeButton;

    public TagWorkbenchScreen(TagWorkbenchMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97726_ = 234;
        this.f_97727_ = 256;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.writeButton = new WidgetButtonExtended(this.f_97735_ + 162, this.f_97736_ + 16, 20, 20, (Component)Component.m_237119_(), b -> this.writeTags()).setRenderStacks(new ItemStack((ItemLike)Items.f_42614_)).setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.tag_workbench.write_button", new Object[0]));
        this.m_142416_((GuiEventListener)this.writeButton);
        this.addButton = new WidgetButtonExtended(this.f_97735_ + 108, this.f_97736_ + 90, 13, 13, "\u25b6", b -> this.addAvailable());
        this.m_142416_((GuiEventListener)this.addButton);
        this.removeButton = new WidgetButtonExtended(this.f_97735_ + 108, this.f_97736_ + 106, 13, 13, "\u25c0", b -> this.removeSelected());
        this.m_142416_((GuiEventListener)this.removeButton);
        this.availableList = new WidgetList(this.f_97735_ + 9, this.f_97736_ + 41, 98, 126, this::onSelected);
        this.m_142416_((GuiEventListener)this.availableList);
        this.selectedList = new WidgetList(this.f_97735_ + 123, this.f_97736_ + 41, 98, 126, this::onSelected);
        this.m_142416_((GuiEventListener)this.selectedList);
    }

    private void writeTags() {
        List l = this.selectedList.getLines().stream().map(ResourceLocation::toString).collect(Collectors.toList());
        NetworkHandler.sendToServer(new PacketGuiButton("write:" + String.join((CharSequence)",", l)));
        this.selectedList.clear();
    }

    private void onSelected(WidgetList<ResourceLocation> w) {
        if (w == this.availableList) {
            this.selectedList.unselectAll();
            if (w.isDoubleClicked()) {
                this.addAvailable();
            }
        } else if (w == this.selectedList) {
            this.availableList.unselectAll();
            if (w.isDoubleClicked()) {
                this.removeSelected();
            }
        }
    }

    private void addAvailable() {
        ResourceLocation rl = this.availableList.getSelectedLine();
        if (rl != null && !this.selectedList.contains(rl)) {
            this.selectedList.add(rl);
        }
    }

    private void removeSelected() {
        ResourceLocation rl = this.selectedList.getSelectedLine();
        if (rl != null) {
            this.selectedList.removeSelected();
        }
    }

    @Override
    public void m_181908_() {
        ItemStack stack1;
        super.m_181908_();
        ItemStack stack = ((TagWorkbenchMenu)this.f_97732_).m_38853_(0).m_7993_();
        if (stack.m_41720_() != this.lastItem) {
            this.availableList.clear();
            ((Holder)ForgeRegistries.ITEMS.getHolder((Object)stack.m_41720_()).orElseThrow()).m_203616_().forEach(tagKey -> this.availableList.add(tagKey.f_203868_()));
            this.availableList.unselectAll();
            this.lastItem = stack.m_41720_();
        }
        if (!ItemStack.m_41728_((ItemStack)(stack1 = ((TagWorkbenchMenu)this.f_97732_).m_38853_(1).m_7993_()), (ItemStack)this.lastPaperStack)) {
            if (stack1.m_41720_() == ModItems.TAG_FILTER.get()) {
                Set<TagKey<Item>> s = TagFilterItem.getConfiguredTagList(stack1);
                s.addAll(this.selectedList.getLines().stream().map(rl -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)rl)).toList());
                this.selectedList.clear();
                s.forEach(rl -> this.selectedList.add(rl.f_203868_()));
            }
            this.selectedList.unselectAll();
            this.lastPaperStack = stack1.m_41777_();
        }
        this.addButton.f_93623_ = this.availableList.getSelectedLine() != null;
        this.removeButton.f_93623_ = this.selectedList.getSelectedLine() != null;
        this.writeButton.f_93623_ = this.selectedList.size() > 0 && (!((TagWorkbenchMenu)this.f_97732_).m_38853_(1).m_7993_().m_41619_() || !((TagWorkbenchMenu)this.f_97732_).m_38853_(2).m_7993_().m_41619_());
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_TAG_WORKBENCH;
    }
}

