/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.InventorySearcherScreen;
import me.desht.pneumaticcraft.client.gui.PastebinScreen;
import me.desht.pneumaticcraft.client.gui.RemoteScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteLayout;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidget;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetButton;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetDropdown;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetLabel;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.WidgetLabelVariable;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.inventory.RemoteMenu;
import me.desht.pneumaticcraft.common.item.RemoteItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateRemoteLayout;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RemoteEditorScreen
extends RemoteScreen {
    private InventorySearcherScreen invSearchGui;
    private PastebinScreen pastebinGui;
    private final List<ActionWidget<?>> widgetTray = new ArrayList();
    private ActionWidget<?> draggingWidget;
    private int dragMouseStartX;
    private int dragMouseStartY;
    private int dragWidgetStartX;
    private int dragWidgetStartY;
    private int oldGuiLeft;
    private int oldGuiTop;

    public RemoteEditorScreen(RemoteMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97726_ = 283;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_REMOTE_EDITOR;
    }

    @Override
    public void m_7856_() {
        if (this.pastebinGui != null && this.pastebinGui.outputTag != null) {
            tag = this.remote.m_41784_();
            tag.m_128365_("actionWidgets", (Tag)this.pastebinGui.outputTag.m_128437_("main", 10));
        } else if (this.remoteLayout != null) {
            tag = this.remote.m_41784_();
            tag.m_128365_("actionWidgets", (Tag)this.remoteLayout.toNBT(this.oldGuiLeft, this.oldGuiTop).m_128437_("actionWidgets", 10));
        }
        if (this.invSearchGui != null && this.invSearchGui.getSearchStack().m_41720_() == ModItems.REMOTE.get()) {
            if (RemoteItem.hasSameSecuritySettings(this.remote, this.invSearchGui.getSearchStack())) {
                this.remoteLayout = new RemoteLayout(this.invSearchGui.getSearchStack(), this.f_97735_, this.f_97736_);
            } else {
                ClientUtils.getClientPlayer().m_5661_((Component)Component.m_237113_((String)"pneumaticcraft.gui.remote.differentSecuritySettings"), false);
            }
        }
        super.m_7856_();
        this.oldGuiLeft = this.f_97735_;
        this.oldGuiTop = this.f_97736_;
        this.widgetTray.clear();
        this.widgetTray.add(new ActionWidgetCheckBox(new WidgetCheckBox(this.f_97735_ + 200, this.f_97736_ + 23, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tray.checkbox.name", new Object[0]))));
        this.widgetTray.add(new ActionWidgetLabel(new WidgetLabelVariable(this.f_97735_ + 200, this.f_97736_ + 38, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tray.label.name", new Object[0]))));
        this.widgetTray.add(new ActionWidgetButton(new WidgetButtonExtended(this.f_97735_ + 200, this.f_97736_ + 53, 50, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tray.button.name", new Object[0]))));
        Objects.requireNonNull(this.f_96547_);
        this.widgetTray.add(new ActionWidgetDropdown(new WidgetComboBox(this.f_96547_, this.f_97735_ + 200, this.f_97736_ + 80, 70, 9 + 1).setFixedOptions(true)));
        for (ActionWidget actionWidget : this.widgetTray) {
            this.m_142416_((GuiEventListener)actionWidget.getWidget());
        }
        WidgetButtonExtended importBtn = new WidgetButtonExtended(this.f_97735_ - 24, this.f_97736_, 20, 20, (Component)Component.m_237119_(), b -> this.doImport()).setRenderStacks(new ItemStack((ItemLike)ModItems.REMOTE.get()));
        importBtn.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.importRemoteButton", new Object[0])));
        this.m_142416_((GuiEventListener)importBtn);
        WidgetButtonExtended widgetButtonExtended = new WidgetButtonExtended(this.f_97735_ - 24, this.f_97736_ + 22, 20, 20, (Component)Component.m_237119_(), b -> this.doPastebin()).setRenderedIcon(Textures.GUI_PASTEBIN_ICON_LOCATION);
        widgetButtonExtended.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.pastebinButton", new Object[0])));
        this.m_142416_((GuiEventListener)widgetButtonExtended);
        WidgetCheckBox snapCheck = new WidgetCheckBox(this.f_97735_ + 194, this.f_97736_ + 105, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.snapToGrid", new Object[0]), b -> ConfigHelper.setGuiRemoteGridSnap(b.checked));
        snapCheck.checked = (Boolean)ConfigHelper.client().general.guiRemoteGridSnap.get();
        this.m_142416_((GuiEventListener)snapCheck);
        this.m_142416_((GuiEventListener)new WidgetLabel(this.f_97735_ + 234, this.f_97736_ + 7, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.widgetTray", new Object[0]).m_130940_(ChatFormatting.DARK_BLUE)).setAlignment(WidgetLabel.Alignment.CENTRE));
    }

    private void doImport() {
        ClientUtils.openContainerGui((MenuType<? extends AbstractContainerMenu>)((MenuType)ModMenuTypes.INVENTORY_SEARCHER.get()), (Component)Component.m_237115_((String)"pneumaticcraft.gui.amadron.addTrade.invSearch"));
        if (this.f_96541_.f_91080_ instanceof InventorySearcherScreen) {
            this.invSearchGui = (InventorySearcherScreen)this.f_96541_.f_91080_;
            this.invSearchGui.setStackPredicate(s -> s.m_41720_() == ModItems.REMOTE.get());
        }
    }

    private void doPastebin() {
        CompoundTag mainTag = new CompoundTag();
        mainTag.m_128365_("main", (Tag)(this.remote.m_41782_() ? this.remote.m_41783_().m_128437_("actionWidgets", 10) : new CompoundTag()));
        this.pastebinGui = new PastebinScreen((Screen)this, mainTag);
        this.f_96541_.m_91152_((Screen)this.pastebinGui);
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.m_280273_(graphics);
        graphics.m_280163_(this.getGuiTexture(), this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 320, 256);
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(-50, 0);
    }

    private boolean isOutsideProgrammingArea(ActionWidget<?> actionWidget) {
        Object w = actionWidget.getWidget();
        return w.m_252754_() < this.f_97735_ || w.m_252907_() < this.f_97736_ || w.m_252754_() + w.m_5711_() > this.f_97735_ + 183 || w.m_252907_() + w.m_93694_() > this.f_97736_ + this.f_97727_;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        int x = (int)mouseX;
        int y = (int)mouseY;
        switch (mouseButton) {
            case 0: {
                for (ActionWidget<?> actionWidget : this.widgetTray) {
                    if (!actionWidget.getWidget().m_198029_()) continue;
                    this.startDrag(actionWidget.copy(), x, y);
                    this.remoteLayout.addWidget(this.draggingWidget);
                    this.m_142416_((GuiEventListener)this.draggingWidget.getWidget());
                    return true;
                }
                if (this.draggingWidget != null) break;
                for (ActionWidget<?> actionWidget : this.remoteLayout.getActionWidgets()) {
                    if (!actionWidget.getWidget().m_198029_()) continue;
                    this.startDrag(actionWidget, x, y);
                    return true;
                }
                break;
            }
            case 1: {
                for (ActionWidget<?> actionWidget : this.remoteLayout.getActionWidgets()) {
                    if (this.isOutsideProgrammingArea(actionWidget) || !actionWidget.getWidget().m_198029_()) continue;
                    Screen screen = actionWidget.getGui(this);
                    if (screen != null) {
                        this.f_96541_.m_91152_(screen);
                    }
                    return true;
                }
                break;
            }
            case 2: {
                for (ActionWidget<?> actionWidget : this.remoteLayout.getActionWidgets()) {
                    if (!actionWidget.getWidget().m_198029_()) continue;
                    this.startDrag(actionWidget.copy(), x, y);
                    this.remoteLayout.addWidget(this.draggingWidget);
                    this.m_142416_((GuiEventListener)this.draggingWidget.getWidget());
                    return true;
                }
                break;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    private void startDrag(ActionWidget<?> widget, int x, int y) {
        this.draggingWidget = widget;
        this.dragMouseStartX = x;
        this.dragMouseStartY = y;
        this.dragWidgetStartX = widget.getWidget().m_252754_();
        this.dragWidgetStartY = widget.getWidget().m_252907_();
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggingWidget != null && this.isOutsideProgrammingArea(this.draggingWidget)) {
            this.remoteLayout.getActionWidgets().remove(this.draggingWidget);
            this.removeWidget((AbstractWidget)this.draggingWidget.getWidget());
        }
        this.draggingWidget = null;
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.draggingWidget != null) {
            int x = (int)mouseX;
            int y = (int)mouseY;
            int x1 = x - this.dragMouseStartX + this.dragWidgetStartX;
            int y1 = y - this.dragMouseStartY + this.dragWidgetStartY;
            if (((Boolean)ConfigHelper.client().general.guiRemoteGridSnap.get()).booleanValue()) {
                x1 = x1 / 4 * 4;
                y1 = y1 / 4 * 4;
            }
            this.draggingWidget.setWidgetPos(x1, y1);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    @Override
    public void onGlobalVariableChange(String variable) {
    }

    public boolean m_6913_() {
        return true;
    }

    @Override
    public void m_7861_() {
        ItemStack stack = ClientUtils.getClientPlayer().m_21120_(((RemoteMenu)this.f_97732_).getHand());
        if (stack.m_41720_() == ModItems.REMOTE.get()) {
            CompoundTag nbt = this.remoteLayout.toNBT(this.f_97735_, this.f_97736_);
            stack.m_41784_().m_128365_("actionWidgets", (Tag)nbt.m_128437_("actionWidgets", 10));
            NetworkHandler.sendToServer(new PacketUpdateRemoteLayout(this.remoteLayout.toNBT(this.f_97735_, this.f_97736_), ((RemoteMenu)this.f_97732_).getHand()));
        }
        super.m_7861_();
    }
}

