/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.ItemSearcherScreen;
import me.desht.pneumaticcraft.client.gui.widget.PNCForgeSlider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.AphorismTileBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAphorismTileUpdate;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.drama.DramaGenerator;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AphorismTileScreen
extends Screen {
    private static final int PANEL_HEIGHT = 88;
    public final AphorismTileBlockEntity tile;
    private String[] textLines;
    public int cursorY;
    public int cursorX;
    public int updateCounter;
    private ItemSearcherScreen itemSearchGui;
    private int panelWidth;

    public AphorismTileScreen(AphorismTileBlockEntity tile, boolean placing) {
        super(new ItemStack((ItemLike)ModBlocks.APHORISM_TILE.get()).m_41786_());
        this.tile = tile;
        this.textLines = tile.getTextLines();
        tile.needMaxLineWidthRecalc();
        if (((Boolean)ConfigHelper.client().general.aphorismDrama.get()).booleanValue() && placing && this.textLines.length == 1 && this.textLines[0].isEmpty()) {
            List<String> l = PneumaticCraftUtils.splitString(DramaGenerator.generateDrama(), 20);
            tile.setTextLines(l.toArray(new String[0]));
            this.textLines = tile.getTextLines();
            NetworkHandler.sendToServer(new PacketAphorismTileUpdate(tile));
        }
        Pair<Integer, Integer> cursor = tile.getCursorPos();
        this.cursorX = (Integer)cursor.getLeft();
        this.cursorY = (Integer)cursor.getRight();
    }

    public void m_7856_() {
        int yPos = (this.f_96544_ - 88) / 2;
        this.m_142416_((GuiEventListener)new PNCForgeSlider(5, yPos, 90, 16, (Component)Component.m_237113_((String)"Margin: "), (Component)Component.m_237119_(), 0.0, 9.0, this.tile.getMarginSize(), true, slider -> this.tile.setMarginSize(slider.getValueInt())));
        WidgetCheckBox cb = new WidgetCheckBox(5, yPos + 22, 0xFFFFFF, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.invisible", new Object[0]), b -> this.tile.setInvisible(b.checked)).setChecked(this.tile.isInvisible());
        this.m_142416_((GuiEventListener)cb);
        this.m_142416_((GuiEventListener)new WidgetLabel(5, yPos + 38, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.aphorismTile.insert", new Object[0]), -128));
        MutableComponent txt = PneumaticCraftUtils.xlate("pneumaticcraft.gui.aphorismTile.insertItem", new Object[0]);
        WidgetButtonExtended itemButton = new WidgetButtonExtended(10, yPos + 50, this.f_96547_.m_92852_((FormattedText)txt) + 10, 18, (Component)txt, b -> this.openItemSelector());
        this.m_142416_((GuiEventListener)itemButton);
        txt = PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstone", new Object[0]);
        WidgetButtonExtended rsButton = new WidgetButtonExtended(10, yPos + 70, this.f_96547_.m_92852_((FormattedText)txt) + 10, 18, (Component)txt, b -> {
            this.textLines[this.cursorY] = this.textLines[this.cursorY] + "{redstone}";
            this.tile.setTextLines(this.textLines);
        });
        this.m_142416_((GuiEventListener)rsButton);
        this.panelWidth = Math.max(100, Math.max(cb.m_5711_(), Math.max(rsButton.m_5711_(), itemButton.m_5711_()))) + 5;
        if (this.itemSearchGui != null && !this.itemSearchGui.getSearchStack().m_41619_()) {
            ResourceLocation regName = PneumaticCraftUtils.getRegistryName(this.itemSearchGui.getSearchStack().m_41720_()).orElseThrow();
            String text = "{item:" + String.valueOf(regName) + "}";
            this.textLines[this.cursorY] = text;
            this.cursorX = text.length();
            this.tile.setTextLines(this.textLines);
            this.itemSearchGui = null;
        }
    }

    private void openItemSelector() {
        ClientUtils.openContainerGui((MenuType<? extends AbstractContainerMenu>)((MenuType)ModMenuTypes.ITEM_SEARCHER.get()), (Component)Component.m_237113_((String)"Searcher"));
        Screen screen = this.f_96541_.f_91080_;
        if (screen instanceof ItemSearcherScreen) {
            ItemSearcherScreen scr;
            this.itemSearchGui = scr = (ItemSearcherScreen)screen;
        }
    }

    public static void openGui(AphorismTileBlockEntity te, boolean placing) {
        if (te != null) {
            Minecraft.m_91087_().m_91152_((Screen)new AphorismTileScreen(te, placing));
        }
    }

    public void m_86600_() {
        ++this.updateCounter;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawPanel(graphics, -5, (this.f_96544_ - 88) / 2, 88, this.panelWidth);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(graphics, this, this.f_96547_, GuiUtils.xlateAndSplit("pneumaticcraft.gui.aphorismTile.helpText", new Object[0]));
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean updateTE = false;
        String curLine = this.textLines[this.cursorY];
        float p = curLine.isEmpty() ? 0.0f : (float)this.cursorX / (float)curLine.length();
        switch (keyCode) {
            case 256: {
                NetworkHandler.sendToServer(new PacketAphorismTileUpdate(this.tile));
                break;
            }
            case 265: {
                --this.cursorY;
                if (this.cursorY < 0) {
                    this.cursorY = this.textLines.length - 1;
                }
                this.cursorX = (int)((float)this.textLines[this.cursorY].length() * p);
                break;
            }
            case 264: 
            case 335: {
                ++this.cursorY;
                if (this.cursorY >= this.textLines.length) {
                    this.cursorY = 0;
                }
                this.cursorX = (int)((float)this.textLines[this.cursorY].length() * p);
                break;
            }
            case 263: {
                if (this.cursorX > 0) {
                    --this.cursorX;
                    if (this.cursorX <= 0 || curLine.charAt(this.cursorX - 1) != '\u00a7') break;
                    --this.cursorX;
                    break;
                }
                if (this.cursorX != 0 || this.cursorY <= 0) break;
                --this.cursorY;
                this.cursorX = this.textLines[this.cursorY].length();
                break;
            }
            case 262: {
                if (this.cursorX < curLine.length()) {
                    ++this.cursorX;
                    if (this.cursorX >= curLine.length() || curLine.charAt(this.cursorX - 1) != '\u00a7') break;
                    ++this.cursorX;
                    break;
                }
                if (this.cursorY >= this.textLines.length - 1) break;
                ++this.cursorY;
                this.cursorX = 0;
                break;
            }
            case 268: {
                this.cursorX = 0;
                break;
            }
            case 269: {
                this.cursorX = curLine.length();
                break;
            }
            case 257: {
                ++this.cursorY;
                int oldCursorX = this.cursorX;
                this.cursorX = 0;
                this.textLines = this.insertLine(this.textLines[this.cursorY - 1].substring(oldCursorX), this.cursorY);
                this.textLines[this.cursorY - 1] = this.textLines[this.cursorY - 1].substring(0, oldCursorX);
                updateTE = true;
                break;
            }
            case 259: {
                if (curLine.length() > 0 && this.cursorX > 0) {
                    this.textLines[this.cursorY] = curLine.substring(0, this.cursorX - 1) + curLine.substring(Math.min(curLine.length(), this.cursorX));
                    --this.cursorX;
                    if (this.cursorX > 0 && this.textLines[this.cursorY].charAt(this.cursorX - 1) == '\u00a7') {
                        this.textLines[this.cursorY] = this.textLines[this.cursorY].substring(0, this.cursorX - 1) + this.textLines[this.cursorY].substring(Math.min(this.textLines[this.cursorY].length(), this.cursorX));
                        --this.cursorX;
                    }
                } else if (this.textLines.length > 1 && this.cursorY > 0) {
                    String line = this.textLines[this.cursorY];
                    this.textLines = (String[])ArrayUtils.remove((Object[])this.textLines, (int)this.cursorY);
                    if (this.cursorY > 0) {
                        --this.cursorY;
                    }
                    this.cursorX = this.textLines[this.cursorY].length();
                    this.textLines[this.cursorY] = this.textLines[this.cursorY] + line;
                }
                updateTE = true;
                break;
            }
            case 261: {
                if (Screen.m_96638_()) {
                    this.textLines = new String[1];
                    this.textLines[0] = "";
                    this.cursorY = 0;
                    this.cursorX = 0;
                } else if (Screen.m_96639_()) {
                    if (this.textLines.length > 1) {
                        this.textLines = (String[])ArrayUtils.remove((Object[])this.textLines, (int)this.cursorY);
                        if (this.cursorY > this.textLines.length - 1) {
                            this.cursorY = this.textLines.length - 1;
                        }
                    } else {
                        this.textLines[0] = "";
                        this.cursorX = 0;
                    }
                } else if (curLine.length() > 0 && this.cursorX < curLine.length()) {
                    int n = curLine.charAt(this.cursorX) == '\u00a7' && this.cursorX < curLine.length() - 1 ? 2 : 1;
                    this.textLines[this.cursorY] = curLine.substring(0, this.cursorX) + curLine.substring(this.cursorX + n);
                } else if (this.cursorY < this.textLines.length - 1) {
                    this.textLines[this.cursorY] = curLine + this.textLines[this.cursorY + 1];
                    this.textLines = (String[])ArrayUtils.remove((Object[])this.textLines, (int)(this.cursorY + 1));
                }
                if (this.cursorX > this.textLines[this.cursorY].length()) {
                    this.cursorX = (int)((float)this.textLines[this.cursorY].length() * p);
                }
                updateTE = true;
            }
        }
        this.tile.setCursorPos(this.cursorX, this.cursorY);
        if (updateTE) {
            this.tile.setTextLines(this.textLines);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char ch, int keyCode) {
        if (SharedConstants.m_136188_((char)ch)) {
            if (Screen.m_96639_()) {
                if (ch >= 'a' && ch <= 'f' || ch >= 'l' && ch <= 'o' || ch == 'r' || ch >= '0' && ch <= '9') {
                    this.textLines[this.cursorY] = this.textLines[this.cursorY].substring(0, this.cursorX) + "\u00a7" + ch + this.textLines[this.cursorY].substring(this.cursorX);
                    this.cursorX += 2;
                }
            } else {
                this.textLines[this.cursorY] = this.textLines[this.cursorY].substring(0, this.cursorX) + ch + this.textLines[this.cursorY].substring(this.cursorX);
                ++this.cursorX;
            }
            this.tile.setTextLines(this.textLines);
        }
        return super.m_5534_(ch, keyCode);
    }

    public void m_7861_() {
        this.tile.needMaxLineWidthRecalc();
        super.m_7861_();
    }

    private String[] insertLine(String line, int pos) {
        String[] newLines = new String[this.textLines.length + 1];
        newLines[pos] = line;
        if (pos > 0) {
            System.arraycopy(this.textLines, 0, newLines, 0, pos);
        }
        if (pos < this.textLines.length) {
            System.arraycopy(this.textLines, pos, newLines, pos + 1, this.textLines.length - pos);
        }
        return newLines;
    }
}

