/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.Validate;

public class TemperatureRange {
    private static final TemperatureRange INVALID = new TemperatureRange(0, 1){

        @Override
        public boolean inRange(int temp) {
            return false;
        }

        @Override
        public boolean inRange(double temp) {
            return false;
        }
    };
    private static final TemperatureRange ANY = new TemperatureRange(0, Integer.MAX_VALUE);
    private final int min;
    private final int max;

    private TemperatureRange(int min, int max) {
        Validate.isTrue((min >= 0 && max >= 0 ? 1 : 0) != 0, (String)"negative temperatures are not accepted!", (Object[])new Object[0]);
        Validate.isTrue((min < max ? 1 : 0) != 0, (String)"min temp must be < max temp!", (Object[])new Object[0]);
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public static TemperatureRange of(int minTemp, int maxTemp) {
        return minTemp == 0 && maxTemp == Integer.MAX_VALUE ? TemperatureRange.any() : new TemperatureRange(minTemp, maxTemp);
    }

    public static TemperatureRange any() {
        return ANY;
    }

    public static TemperatureRange min(int minTemp) {
        return new TemperatureRange(minTemp, Integer.MAX_VALUE);
    }

    public static TemperatureRange max(int maxTemp) {
        return new TemperatureRange(0, maxTemp);
    }

    public static TemperatureRange read(FriendlyByteBuf buffer) {
        return new TemperatureRange(buffer.m_130242_(), buffer.m_130242_());
    }

    public boolean inRange(int temp) {
        return temp >= this.min && temp <= this.max;
    }

    public boolean inRange(double temp) {
        return (int)temp >= this.min && (int)temp <= this.max;
    }

    public static TemperatureRange invalid() {
        return INVALID;
    }

    public boolean isAny() {
        return this == ANY;
    }

    public boolean hasMin() {
        return this.min > 0;
    }

    public boolean hasMax() {
        return this.max < Integer.MAX_VALUE;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.min);
        buffer.m_130130_(this.max);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.min > -2147483647) {
            json.addProperty("min_temp", (Number)this.min);
        }
        if (this.max < Integer.MAX_VALUE) {
            json.addProperty("max_temp", (Number)this.max);
        }
        return json;
    }

    public static TemperatureRange fromJson(JsonObject json) {
        if (!json.has("min_temp") && !json.has("max_temp")) {
            return TemperatureRange.any();
        }
        if (!json.has("min_temp")) {
            return TemperatureRange.max(GsonHelper.m_13927_((JsonObject)json, (String)"max_temp"));
        }
        if (!json.has("max_temp")) {
            return TemperatureRange.min(GsonHelper.m_13927_((JsonObject)json, (String)"min_temp"));
        }
        return TemperatureRange.of(GsonHelper.m_13927_((JsonObject)json, (String)"min_temp"), GsonHelper.m_13927_((JsonObject)json, (String)"max_temp"));
    }

    public String asString(TemperatureScale scale) {
        if (this.isAny()) {
            return "any";
        }
        if (this == TemperatureRange.invalid()) {
            return "invalid";
        }
        if (this.min > -2147483647) {
            if (this.max < Integer.MAX_VALUE) {
                return scale.convertFromKelvin(this.min) + scale.symbol() + " - " + scale.convertFromKelvin(this.max) + scale.symbol();
            }
            return ">= " + scale.convertFromKelvin(this.min) + scale.symbol();
        }
        if (this.max < Integer.MAX_VALUE) {
            return "<= " + scale.convertFromKelvin(this.max) + scale.symbol();
        }
        return "any";
    }

    public static enum TemperatureScale {
        KELVIN("K"),
        CELSIUS("\u00b0C"),
        FAHRENHEIT("\u00b0F");

        private final String symbol;

        private TemperatureScale(String symbol) {
            this.symbol = symbol;
        }

        public float convertFromKelvin(float tempIn) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CELSIUS -> tempIn - 273.0f;
                case FAHRENHEIT -> (tempIn - 273.0f) * 1.8f + 32.0f;
                case KELVIN -> tempIn;
            };
        }

        public String symbol() {
            return this.symbol;
        }
    }
}

